/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.core;

import android.graphics.RectF;
import com.google.mediapipe.formats.proto.RectProto;
import com.google.mediapipe.framework.MediaPipeException;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.ProtoUtil;
import com.google.mediapipe.framework.image.MPImage;
import com.google.mediapipe.tasks.core.TaskResult;
import com.google.mediapipe.tasks.core.TaskRunner;
import com.google.mediapipe.tasks.vision.core.ImageProcessingOptions;
import com.google.mediapipe.tasks.vision.core.RunningMode;
import com.google.protobuf.MessageLite;
import java.util.HashMap;
import java.util.Map;

public class BaseVisionTaskApi
implements AutoCloseable {
    protected static final long MICROSECONDS_PER_MILLISECOND = 1000L;
    protected final TaskRunner runner;
    protected final RunningMode runningMode;
    protected final String imageStreamName;
    protected final String normRectStreamName;

    public BaseVisionTaskApi(TaskRunner runner, RunningMode runningMode, String imageStreamName, String normRectStreamName) {
        this.runner = runner;
        this.runningMode = runningMode;
        this.imageStreamName = imageStreamName;
        this.normRectStreamName = normRectStreamName;
    }

    protected TaskResult processImageData(MPImage image, ImageProcessingOptions imageProcessingOptions) {
        HashMap<String, Packet> inputPackets = new HashMap<String, Packet>();
        inputPackets.put(this.imageStreamName, this.runner.getPacketCreator().createImage(image));
        if (!this.normRectStreamName.isEmpty()) {
            inputPackets.put(this.normRectStreamName, this.runner.getPacketCreator().createProto((MessageLite)BaseVisionTaskApi.convertToNormalizedRect(imageProcessingOptions, image)));
        }
        return this.processImageData(inputPackets);
    }

    protected TaskResult processImageData(Map<String, Packet> inputPackets) {
        if (this.runningMode != RunningMode.IMAGE) {
            throw new MediaPipeException(MediaPipeException.StatusCode.FAILED_PRECONDITION.ordinal(), "Task is not initialized with the image mode. Current running mode:" + this.runningMode.name());
        }
        return this.runner.process(inputPackets);
    }

    protected TaskResult processVideoData(MPImage image, ImageProcessingOptions imageProcessingOptions, long timestampMs) {
        HashMap<String, Packet> inputPackets = new HashMap<String, Packet>();
        inputPackets.put(this.imageStreamName, this.runner.getPacketCreator().createImage(image));
        if (!this.normRectStreamName.isEmpty()) {
            inputPackets.put(this.normRectStreamName, this.runner.getPacketCreator().createProto((MessageLite)BaseVisionTaskApi.convertToNormalizedRect(imageProcessingOptions, image)));
        }
        return this.processVideoData(inputPackets, timestampMs);
    }

    protected TaskResult processVideoData(Map<String, Packet> inputPackets, long timestampMs) {
        if (this.runningMode != RunningMode.VIDEO) {
            throw new MediaPipeException(MediaPipeException.StatusCode.FAILED_PRECONDITION.ordinal(), "Task is not initialized with the video mode. Current running mode:" + this.runningMode.name());
        }
        return this.runner.process(inputPackets, timestampMs * 1000L);
    }

    protected void sendLiveStreamData(MPImage image, ImageProcessingOptions imageProcessingOptions, long timestampMs) {
        HashMap<String, Packet> inputPackets = new HashMap<String, Packet>();
        inputPackets.put(this.imageStreamName, this.runner.getPacketCreator().createImage(image));
        if (!this.normRectStreamName.isEmpty()) {
            inputPackets.put(this.normRectStreamName, this.runner.getPacketCreator().createProto((MessageLite)BaseVisionTaskApi.convertToNormalizedRect(imageProcessingOptions, image)));
        }
        this.sendLiveStreamData(inputPackets, timestampMs);
    }

    protected void sendLiveStreamData(Map<String, Packet> inputPackets, long timestampMs) {
        if (this.runningMode != RunningMode.LIVE_STREAM) {
            throw new MediaPipeException(MediaPipeException.StatusCode.FAILED_PRECONDITION.ordinal(), "Task is not initialized with the live stream mode. Current running mode:" + this.runningMode.name());
        }
        this.runner.send(inputPackets, timestampMs * 1000L);
    }

    @Override
    public void close() {
        this.runner.close();
    }

    protected static RectProto.NormalizedRect convertToNormalizedRect(ImageProcessingOptions imageProcessingOptions, MPImage image) {
        RectF regionOfInterest = imageProcessingOptions.regionOfInterest().isPresent() ? imageProcessingOptions.regionOfInterest().get() : new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        boolean requiresSwap = imageProcessingOptions.rotationDegrees() % 180 != 0;
        return (RectProto.NormalizedRect)RectProto.NormalizedRect.newBuilder().setXCenter(regionOfInterest.centerX()).setYCenter(regionOfInterest.centerY()).setWidth(requiresSwap ? regionOfInterest.height() * (float)image.getHeight() / (float)image.getWidth() : regionOfInterest.width()).setHeight(requiresSwap ? regionOfInterest.width() * (float)image.getWidth() / (float)image.getHeight() : regionOfInterest.height()).setRotation((float)(-Math.PI) * (float)imageProcessingOptions.rotationDegrees() / 180.0f).build();
    }

    public static long generateResultTimestampMs(RunningMode runningMode, Packet packet) {
        if (runningMode == RunningMode.IMAGE) {
            return -1L;
        }
        return packet.getTimestamp() / 1000L;
    }

    static {
        ProtoUtil.registerTypeName(RectProto.NormalizedRect.class, (String)"mediapipe.NormalizedRect");
    }
}

