/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.core;

import android.graphics.RectF;
import com.google.auto.value.AutoValue;
import com.google.mediapipe.tasks.vision.core.AutoValue_ImageProcessingOptions;
import java.util.Optional;

@AutoValue
public abstract class ImageProcessingOptions {
    public abstract Optional<RectF> regionOfInterest();

    public abstract int rotationDegrees();

    public static Builder builder() {
        return new AutoValue_ImageProcessingOptions.Builder().setRotationDegrees(0);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setRegionOfInterest(RectF var1);

        public abstract Builder setRotationDegrees(int var1);

        abstract ImageProcessingOptions autoBuild();

        public final ImageProcessingOptions build() {
            ImageProcessingOptions options = this.autoBuild();
            if (options.regionOfInterest().isPresent()) {
                RectF roi = options.regionOfInterest().get();
                if (roi.left >= roi.right || roi.top >= roi.bottom) {
                    throw new IllegalArgumentException(String.format("Expected left < right and top < bottom, found: %s.", roi.toShortString()));
                }
                if (roi.left < 0.0f || roi.right > 1.0f || roi.top < 0.0f || roi.bottom > 1.0f) {
                    throw new IllegalArgumentException(String.format("Expected RectF values in [0,1], found: %s.", roi.toShortString()));
                }
            }
            if (options.rotationDegrees() % 90 != 0) {
                throw new IllegalArgumentException(String.format("Expected rotation to be a multiple of 90\u00b0, found: %d.", options.rotationDegrees()));
            }
            return options;
        }
    }
}

