/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.facelandmarker;

import com.google.mediapipe.framework.image.MPImage;
import com.google.mediapipe.tasks.core.BaseOptions;
import com.google.mediapipe.tasks.core.ErrorListener;
import com.google.mediapipe.tasks.core.OutputHandler;
import com.google.mediapipe.tasks.vision.core.RunningMode;
import com.google.mediapipe.tasks.vision.facelandmarker.FaceLandmarker;
import com.google.mediapipe.tasks.vision.facelandmarker.FaceLandmarkerResult;
import java.util.Optional;

final class AutoValue_FaceLandmarker_FaceLandmarkerOptions
extends FaceLandmarker.FaceLandmarkerOptions {
    private final BaseOptions baseOptions;
    private final RunningMode runningMode;
    private final Optional<Integer> numFaces;
    private final Optional<Float> minFaceDetectionConfidence;
    private final Optional<Float> minFacePresenceConfidence;
    private final Optional<Float> minTrackingConfidence;
    private final Boolean outputFaceBlendshapes;
    private final Boolean outputFacialTransformationMatrixes;
    private final Optional<OutputHandler.ResultListener<FaceLandmarkerResult, MPImage>> resultListener;
    private final Optional<ErrorListener> errorListener;

    private AutoValue_FaceLandmarker_FaceLandmarkerOptions(BaseOptions baseOptions, RunningMode runningMode, Optional<Integer> numFaces, Optional<Float> minFaceDetectionConfidence, Optional<Float> minFacePresenceConfidence, Optional<Float> minTrackingConfidence, Boolean outputFaceBlendshapes, Boolean outputFacialTransformationMatrixes, Optional<OutputHandler.ResultListener<FaceLandmarkerResult, MPImage>> resultListener, Optional<ErrorListener> errorListener) {
        this.baseOptions = baseOptions;
        this.runningMode = runningMode;
        this.numFaces = numFaces;
        this.minFaceDetectionConfidence = minFaceDetectionConfidence;
        this.minFacePresenceConfidence = minFacePresenceConfidence;
        this.minTrackingConfidence = minTrackingConfidence;
        this.outputFaceBlendshapes = outputFaceBlendshapes;
        this.outputFacialTransformationMatrixes = outputFacialTransformationMatrixes;
        this.resultListener = resultListener;
        this.errorListener = errorListener;
    }

    @Override
    BaseOptions baseOptions() {
        return this.baseOptions;
    }

    @Override
    RunningMode runningMode() {
        return this.runningMode;
    }

    @Override
    Optional<Integer> numFaces() {
        return this.numFaces;
    }

    @Override
    Optional<Float> minFaceDetectionConfidence() {
        return this.minFaceDetectionConfidence;
    }

    @Override
    Optional<Float> minFacePresenceConfidence() {
        return this.minFacePresenceConfidence;
    }

    @Override
    Optional<Float> minTrackingConfidence() {
        return this.minTrackingConfidence;
    }

    @Override
    Boolean outputFaceBlendshapes() {
        return this.outputFaceBlendshapes;
    }

    @Override
    Boolean outputFacialTransformationMatrixes() {
        return this.outputFacialTransformationMatrixes;
    }

    @Override
    Optional<OutputHandler.ResultListener<FaceLandmarkerResult, MPImage>> resultListener() {
        return this.resultListener;
    }

    @Override
    Optional<ErrorListener> errorListener() {
        return this.errorListener;
    }

    public String toString() {
        return "FaceLandmarkerOptions{baseOptions=" + this.baseOptions + ", runningMode=" + (Object)((Object)this.runningMode) + ", numFaces=" + this.numFaces + ", minFaceDetectionConfidence=" + this.minFaceDetectionConfidence + ", minFacePresenceConfidence=" + this.minFacePresenceConfidence + ", minTrackingConfidence=" + this.minTrackingConfidence + ", outputFaceBlendshapes=" + this.outputFaceBlendshapes + ", outputFacialTransformationMatrixes=" + this.outputFacialTransformationMatrixes + ", resultListener=" + this.resultListener + ", errorListener=" + this.errorListener + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FaceLandmarker.FaceLandmarkerOptions) {
            FaceLandmarker.FaceLandmarkerOptions that = (FaceLandmarker.FaceLandmarkerOptions)((Object)o);
            return this.baseOptions.equals(that.baseOptions()) && this.runningMode.equals((Object)that.runningMode()) && this.numFaces.equals(that.numFaces()) && this.minFaceDetectionConfidence.equals(that.minFaceDetectionConfidence()) && this.minFacePresenceConfidence.equals(that.minFacePresenceConfidence()) && this.minTrackingConfidence.equals(that.minTrackingConfidence()) && this.outputFaceBlendshapes.equals(that.outputFaceBlendshapes()) && this.outputFacialTransformationMatrixes.equals(that.outputFacialTransformationMatrixes()) && this.resultListener.equals(that.resultListener()) && this.errorListener.equals(that.errorListener());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.baseOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.runningMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.numFaces.hashCode();
        h$ *= 1000003;
        h$ ^= this.minFaceDetectionConfidence.hashCode();
        h$ *= 1000003;
        h$ ^= this.minFacePresenceConfidence.hashCode();
        h$ *= 1000003;
        h$ ^= this.minTrackingConfidence.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputFaceBlendshapes.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputFacialTransformationMatrixes.hashCode();
        h$ *= 1000003;
        h$ ^= this.resultListener.hashCode();
        h$ *= 1000003;
        return h$ ^= this.errorListener.hashCode();
    }

    static final class Builder
    extends FaceLandmarker.FaceLandmarkerOptions.Builder {
        private BaseOptions baseOptions;
        private RunningMode runningMode;
        private Optional<Integer> numFaces = Optional.empty();
        private Optional<Float> minFaceDetectionConfidence = Optional.empty();
        private Optional<Float> minFacePresenceConfidence = Optional.empty();
        private Optional<Float> minTrackingConfidence = Optional.empty();
        private Boolean outputFaceBlendshapes;
        private Boolean outputFacialTransformationMatrixes;
        private Optional<OutputHandler.ResultListener<FaceLandmarkerResult, MPImage>> resultListener = Optional.empty();
        private Optional<ErrorListener> errorListener = Optional.empty();

        Builder() {
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setBaseOptions(BaseOptions baseOptions) {
            if (baseOptions == null) {
                throw new NullPointerException("Null baseOptions");
            }
            this.baseOptions = baseOptions;
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setRunningMode(RunningMode runningMode) {
            if (runningMode == null) {
                throw new NullPointerException("Null runningMode");
            }
            this.runningMode = runningMode;
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setNumFaces(Integer numFaces) {
            this.numFaces = Optional.of(numFaces);
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setMinFaceDetectionConfidence(Float minFaceDetectionConfidence) {
            this.minFaceDetectionConfidence = Optional.of(minFaceDetectionConfidence);
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setMinFacePresenceConfidence(Float minFacePresenceConfidence) {
            this.minFacePresenceConfidence = Optional.of(minFacePresenceConfidence);
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setMinTrackingConfidence(Float minTrackingConfidence) {
            this.minTrackingConfidence = Optional.of(minTrackingConfidence);
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setOutputFaceBlendshapes(Boolean outputFaceBlendshapes) {
            if (outputFaceBlendshapes == null) {
                throw new NullPointerException("Null outputFaceBlendshapes");
            }
            this.outputFaceBlendshapes = outputFaceBlendshapes;
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setOutputFacialTransformationMatrixes(Boolean outputFacialTransformationMatrixes) {
            if (outputFacialTransformationMatrixes == null) {
                throw new NullPointerException("Null outputFacialTransformationMatrixes");
            }
            this.outputFacialTransformationMatrixes = outputFacialTransformationMatrixes;
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setResultListener(OutputHandler.ResultListener<FaceLandmarkerResult, MPImage> resultListener) {
            this.resultListener = Optional.of(resultListener);
            return this;
        }

        @Override
        public FaceLandmarker.FaceLandmarkerOptions.Builder setErrorListener(ErrorListener errorListener) {
            this.errorListener = Optional.of(errorListener);
            return this;
        }

        @Override
        FaceLandmarker.FaceLandmarkerOptions autoBuild() {
            String missing = "";
            if (this.baseOptions == null) {
                missing = missing + " baseOptions";
            }
            if (this.runningMode == null) {
                missing = missing + " runningMode";
            }
            if (this.outputFaceBlendshapes == null) {
                missing = missing + " outputFaceBlendshapes";
            }
            if (this.outputFacialTransformationMatrixes == null) {
                missing = missing + " outputFacialTransformationMatrixes";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FaceLandmarker_FaceLandmarkerOptions(this.baseOptions, this.runningMode, this.numFaces, this.minFaceDetectionConfidence, this.minFacePresenceConfidence, this.minTrackingConfidence, this.outputFaceBlendshapes, this.outputFacialTransformationMatrixes, this.resultListener, this.errorListener);
        }
    }
}

