/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.facelandmarker;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.google.auto.value.AutoValue;
import com.google.mediapipe.formats.proto.ClassificationProto;
import com.google.mediapipe.formats.proto.LandmarkProto;
import com.google.mediapipe.framework.AndroidPacketGetter;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.PacketGetter;
import com.google.mediapipe.framework.image.BitmapImageBuilder;
import com.google.mediapipe.framework.image.MPImage;
import com.google.mediapipe.proto.CalculatorOptionsProto;
import com.google.mediapipe.tasks.components.containers.Connection;
import com.google.mediapipe.tasks.core.BaseOptions;
import com.google.mediapipe.tasks.core.ErrorListener;
import com.google.mediapipe.tasks.core.OutputHandler;
import com.google.mediapipe.tasks.core.TaskInfo;
import com.google.mediapipe.tasks.core.TaskOptions;
import com.google.mediapipe.tasks.core.TaskRunner;
import com.google.mediapipe.tasks.core.proto.BaseOptionsProto;
import com.google.mediapipe.tasks.vision.core.BaseVisionTaskApi;
import com.google.mediapipe.tasks.vision.core.ImageProcessingOptions;
import com.google.mediapipe.tasks.vision.core.RunningMode;
import com.google.mediapipe.tasks.vision.facedetector.proto.FaceDetectorGraphOptionsProto;
import com.google.mediapipe.tasks.vision.facegeometry.proto.FaceGeometryProto;
import com.google.mediapipe.tasks.vision.facelandmarker.AutoValue_FaceLandmarker_FaceLandmarkerOptions;
import com.google.mediapipe.tasks.vision.facelandmarker.FaceLandmarkerResult;
import com.google.mediapipe.tasks.vision.facelandmarker.FaceLandmarksConnections;
import com.google.mediapipe.tasks.vision.facelandmarker.proto.FaceLandmarkerGraphOptionsProto;
import com.google.mediapipe.tasks.vision.facelandmarker.proto.FaceLandmarksDetectorGraphOptionsProto;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.Parser;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class FaceLandmarker
extends BaseVisionTaskApi {
    private static final String TAG = FaceLandmarker.class.getSimpleName();
    private static final String IMAGE_IN_STREAM_NAME = "image_in";
    private static final String NORM_RECT_IN_STREAM_NAME = "norm_rect_in";
    private static final List<String> INPUT_STREAMS = Collections.unmodifiableList(Arrays.asList("IMAGE:image_in", "NORM_RECT:norm_rect_in"));
    private static final int LANDMARKS_OUT_STREAM_INDEX = 0;
    private static final int IMAGE_OUT_STREAM_INDEX = 1;
    private static int blendshapesOutStreamIndex = -1;
    private static int faceGeometryOutStreamIndex = -1;
    private static final String TASK_GRAPH_NAME = "mediapipe.tasks.vision.face_landmarker.FaceLandmarkerGraph";
    public static final Set<Connection> FACE_LANDMARKS_LIPS;
    public static final Set<Connection> FACE_LANDMARKS_LEFT_EYE;
    public static final Set<Connection> FACE_LANDMARKS_LEFT_EYE_BROW;
    public static final Set<Connection> FACE_LANDMARKS_LEFT_IRIS;
    public static final Set<Connection> FACE_LANDMARKS_RIGHT_EYE;
    public static final Set<Connection> FACE_LANDMARKS_RIGHT_EYE_BROW;
    public static final Set<Connection> FACE_LANDMARKS_RIGHT_IRIS;
    public static final Set<Connection> FACE_LANDMARKS_FACE_OVAL;
    public static final Set<Connection> FACE_LANDMARKS_CONNECTORS;
    public static final Set<Connection> FACE_LANDMARKS_TESSELATION;

    public static FaceLandmarker createFromFile(Context context, String modelAssetPath) {
        BaseOptions baseOptions = BaseOptions.builder().setModelAssetPath(modelAssetPath).build();
        return FaceLandmarker.createFromOptions(context, FaceLandmarkerOptions.builder().setBaseOptions(baseOptions).build());
    }

    public static FaceLandmarker createFromFile(Context context, File modelAssetFile) throws IOException {
        try (ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)modelAssetFile, (int)0x10000000);){
            BaseOptions baseOptions = BaseOptions.builder().setModelAssetFileDescriptor(Integer.valueOf(descriptor.getFd())).build();
            FaceLandmarker faceLandmarker = FaceLandmarker.createFromOptions(context, FaceLandmarkerOptions.builder().setBaseOptions(baseOptions).build());
            return faceLandmarker;
        }
    }

    public static FaceLandmarker createFromBuffer(Context context, ByteBuffer modelAssetBuffer) {
        BaseOptions baseOptions = BaseOptions.builder().setModelAssetBuffer(modelAssetBuffer).build();
        return FaceLandmarker.createFromOptions(context, FaceLandmarkerOptions.builder().setBaseOptions(baseOptions).build());
    }

    public static FaceLandmarker createFromOptions(Context context, final FaceLandmarkerOptions landmarkerOptions) {
        ArrayList<String> outputStreams = new ArrayList<String>();
        outputStreams.add("NORM_LANDMARKS:face_landmarks");
        outputStreams.add("IMAGE:image_out");
        if (landmarkerOptions.outputFaceBlendshapes().booleanValue()) {
            outputStreams.add("BLENDSHAPES:face_blendshapes");
            blendshapesOutStreamIndex = outputStreams.size() - 1;
        }
        if (landmarkerOptions.outputFacialTransformationMatrixes().booleanValue()) {
            outputStreams.add("FACE_GEOMETRY:face_geometry");
            faceGeometryOutStreamIndex = outputStreams.size() - 1;
        }
        OutputHandler handler = new OutputHandler();
        handler.setOutputPacketConverter((OutputHandler.OutputPacketConverter)new OutputHandler.OutputPacketConverter<FaceLandmarkerResult, MPImage>(){

            public FaceLandmarkerResult convertToTaskResult(List<Packet> packets) {
                if (packets.get(0).isEmpty()) {
                    return FaceLandmarkerResult.create(new ArrayList<LandmarkProto.NormalizedLandmarkList>(), Optional.empty(), Optional.empty(), BaseVisionTaskApi.generateResultTimestampMs(landmarkerOptions.runningMode(), packets.get(0)));
                }
                Optional<List<ClassificationProto.ClassificationList>> blendshapes = Optional.empty();
                if (landmarkerOptions.outputFaceBlendshapes().booleanValue()) {
                    blendshapes = Optional.of(PacketGetter.getProtoVector((Packet)packets.get(blendshapesOutStreamIndex), (Parser)ClassificationProto.ClassificationList.parser()));
                }
                Optional<List<Object>> facialTransformationMatrixes = Optional.empty();
                if (landmarkerOptions.outputFacialTransformationMatrixes().booleanValue()) {
                    List faceGeometryList = PacketGetter.getProtoVector((Packet)packets.get(faceGeometryOutStreamIndex), (Parser)FaceGeometryProto.FaceGeometry.parser());
                    facialTransformationMatrixes = Optional.of(new ArrayList());
                    for (FaceGeometryProto.FaceGeometry faceGeometry : faceGeometryList) {
                        facialTransformationMatrixes.get().add(faceGeometry.getPoseTransformMatrix());
                    }
                }
                return FaceLandmarkerResult.create(PacketGetter.getProtoVector((Packet)packets.get(0), (Parser)LandmarkProto.NormalizedLandmarkList.parser()), blendshapes, facialTransformationMatrixes, BaseVisionTaskApi.generateResultTimestampMs(landmarkerOptions.runningMode(), packets.get(0)));
            }

            public MPImage convertToTaskInput(List<Packet> packets) {
                return new BitmapImageBuilder(AndroidPacketGetter.getBitmapFromRgb((Packet)packets.get(1))).build();
            }
        });
        landmarkerOptions.resultListener().ifPresent(arg_0 -> ((OutputHandler)handler).setResultListener(arg_0));
        landmarkerOptions.errorListener().ifPresent(arg_0 -> ((OutputHandler)handler).setErrorListener(arg_0));
        TaskRunner runner = TaskRunner.create((Context)context, (TaskInfo)TaskInfo.builder().setTaskName(FaceLandmarker.class.getSimpleName()).setTaskRunningModeName(landmarkerOptions.runningMode().name()).setTaskGraphName(TASK_GRAPH_NAME).setInputStreams(INPUT_STREAMS).setOutputStreams(outputStreams).setTaskOptions((TaskOptions)landmarkerOptions).setEnableFlowLimiting(Boolean.valueOf(landmarkerOptions.runningMode() == RunningMode.LIVE_STREAM)).build(), (OutputHandler)handler);
        return new FaceLandmarker(runner, landmarkerOptions.runningMode());
    }

    private FaceLandmarker(TaskRunner taskRunner, RunningMode runningMode) {
        super(taskRunner, runningMode, IMAGE_IN_STREAM_NAME, NORM_RECT_IN_STREAM_NAME);
    }

    public FaceLandmarkerResult detect(MPImage image) {
        return this.detect(image, ImageProcessingOptions.builder().build());
    }

    public FaceLandmarkerResult detect(MPImage image, ImageProcessingOptions imageProcessingOptions) {
        FaceLandmarker.validateImageProcessingOptions(imageProcessingOptions);
        return (FaceLandmarkerResult)this.processImageData(image, imageProcessingOptions);
    }

    public FaceLandmarkerResult detectForVideo(MPImage image, long timestampMs) {
        return this.detectForVideo(image, ImageProcessingOptions.builder().build(), timestampMs);
    }

    public FaceLandmarkerResult detectForVideo(MPImage image, ImageProcessingOptions imageProcessingOptions, long timestampMs) {
        FaceLandmarker.validateImageProcessingOptions(imageProcessingOptions);
        return (FaceLandmarkerResult)this.processVideoData(image, imageProcessingOptions, timestampMs);
    }

    public void detectAsync(MPImage image, long timestampMs) {
        this.detectAsync(image, ImageProcessingOptions.builder().build(), timestampMs);
    }

    public void detectAsync(MPImage image, ImageProcessingOptions imageProcessingOptions, long timestampMs) {
        FaceLandmarker.validateImageProcessingOptions(imageProcessingOptions);
        this.sendLiveStreamData(image, imageProcessingOptions, timestampMs);
    }

    private static void validateImageProcessingOptions(ImageProcessingOptions imageProcessingOptions) {
        if (imageProcessingOptions.regionOfInterest().isPresent()) {
            throw new IllegalArgumentException("FaceLandmarker doesn't support region-of-interest.");
        }
    }

    static {
        System.loadLibrary("mediapipe_tasks_vision_jni");
        FACE_LANDMARKS_LIPS = FaceLandmarksConnections.FACE_LANDMARKS_LIPS;
        FACE_LANDMARKS_LEFT_EYE = FaceLandmarksConnections.FACE_LANDMARKS_LEFT_EYE;
        FACE_LANDMARKS_LEFT_EYE_BROW = FaceLandmarksConnections.FACE_LANDMARKS_LEFT_EYE_BROW;
        FACE_LANDMARKS_LEFT_IRIS = FaceLandmarksConnections.FACE_LANDMARKS_LEFT_IRIS;
        FACE_LANDMARKS_RIGHT_EYE = FaceLandmarksConnections.FACE_LANDMARKS_RIGHT_EYE;
        FACE_LANDMARKS_RIGHT_EYE_BROW = FaceLandmarksConnections.FACE_LANDMARKS_RIGHT_EYE_BROW;
        FACE_LANDMARKS_RIGHT_IRIS = FaceLandmarksConnections.FACE_LANDMARKS_RIGHT_IRIS;
        FACE_LANDMARKS_FACE_OVAL = FaceLandmarksConnections.FACE_LANDMARKS_FACE_OVAL;
        FACE_LANDMARKS_CONNECTORS = FaceLandmarksConnections.FACE_LANDMARKS_CONNECTORS;
        FACE_LANDMARKS_TESSELATION = FaceLandmarksConnections.FACE_LANDMARKS_TESSELATION;
    }

    @AutoValue
    public static abstract class FaceLandmarkerOptions
    extends TaskOptions {
        abstract BaseOptions baseOptions();

        abstract RunningMode runningMode();

        abstract Optional<Integer> numFaces();

        abstract Optional<Float> minFaceDetectionConfidence();

        abstract Optional<Float> minFacePresenceConfidence();

        abstract Optional<Float> minTrackingConfidence();

        abstract Boolean outputFaceBlendshapes();

        abstract Boolean outputFacialTransformationMatrixes();

        abstract Optional<OutputHandler.ResultListener<FaceLandmarkerResult, MPImage>> resultListener();

        abstract Optional<ErrorListener> errorListener();

        public static Builder builder() {
            return new AutoValue_FaceLandmarker_FaceLandmarkerOptions.Builder().setRunningMode(RunningMode.IMAGE).setNumFaces(1).setMinFaceDetectionConfidence(Float.valueOf(0.5f)).setMinFacePresenceConfidence(Float.valueOf(0.5f)).setMinTrackingConfidence(Float.valueOf(0.5f)).setOutputFaceBlendshapes(false).setOutputFacialTransformationMatrixes(false);
        }

        public CalculatorOptionsProto.CalculatorOptions convertToCalculatorOptionsProto() {
            FaceLandmarkerGraphOptionsProto.FaceLandmarkerGraphOptions.Builder taskOptionsBuilder = FaceLandmarkerGraphOptionsProto.FaceLandmarkerGraphOptions.newBuilder().setBaseOptions((BaseOptionsProto.BaseOptions)((BaseOptionsProto.BaseOptions.Builder)BaseOptionsProto.BaseOptions.newBuilder().setUseStreamMode(this.runningMode() != RunningMode.IMAGE).mergeFrom((GeneratedMessageLite)this.convertBaseOptionsToProto(this.baseOptions()))).build());
            FaceDetectorGraphOptionsProto.FaceDetectorGraphOptions.Builder faceDetectorGraphOptionsBuilder = FaceDetectorGraphOptionsProto.FaceDetectorGraphOptions.newBuilder();
            this.numFaces().ifPresent(arg_0 -> ((FaceDetectorGraphOptionsProto.FaceDetectorGraphOptions.Builder)faceDetectorGraphOptionsBuilder).setNumFaces(arg_0));
            this.minFaceDetectionConfidence().ifPresent(arg_0 -> ((FaceDetectorGraphOptionsProto.FaceDetectorGraphOptions.Builder)faceDetectorGraphOptionsBuilder).setMinDetectionConfidence(arg_0));
            FaceLandmarksDetectorGraphOptionsProto.FaceLandmarksDetectorGraphOptions.Builder faceLandmarksDetectorGraphOptionsBuilder = FaceLandmarksDetectorGraphOptionsProto.FaceLandmarksDetectorGraphOptions.newBuilder();
            this.minFacePresenceConfidence().ifPresent(arg_0 -> ((FaceLandmarksDetectorGraphOptionsProto.FaceLandmarksDetectorGraphOptions.Builder)faceLandmarksDetectorGraphOptionsBuilder).setMinDetectionConfidence(arg_0));
            this.minTrackingConfidence().ifPresent(arg_0 -> ((FaceLandmarkerGraphOptionsProto.FaceLandmarkerGraphOptions.Builder)taskOptionsBuilder).setMinTrackingConfidence(arg_0));
            taskOptionsBuilder.setFaceDetectorGraphOptions((FaceDetectorGraphOptionsProto.FaceDetectorGraphOptions)faceDetectorGraphOptionsBuilder.build()).setFaceLandmarksDetectorGraphOptions((FaceLandmarksDetectorGraphOptionsProto.FaceLandmarksDetectorGraphOptions)faceLandmarksDetectorGraphOptionsBuilder.build());
            return (CalculatorOptionsProto.CalculatorOptions)((CalculatorOptionsProto.CalculatorOptions.Builder)CalculatorOptionsProto.CalculatorOptions.newBuilder().setExtension((ExtensionLite)FaceLandmarkerGraphOptionsProto.FaceLandmarkerGraphOptions.ext, (Object)((FaceLandmarkerGraphOptionsProto.FaceLandmarkerGraphOptions)taskOptionsBuilder.build()))).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setBaseOptions(BaseOptions var1);

            public abstract Builder setRunningMode(RunningMode var1);

            public abstract Builder setNumFaces(Integer var1);

            public abstract Builder setMinFaceDetectionConfidence(Float var1);

            public abstract Builder setMinFacePresenceConfidence(Float var1);

            public abstract Builder setMinTrackingConfidence(Float var1);

            public abstract Builder setOutputFaceBlendshapes(Boolean var1);

            public abstract Builder setOutputFacialTransformationMatrixes(Boolean var1);

            public abstract Builder setResultListener(OutputHandler.ResultListener<FaceLandmarkerResult, MPImage> var1);

            public abstract Builder setErrorListener(ErrorListener var1);

            abstract FaceLandmarkerOptions autoBuild();

            public final FaceLandmarkerOptions build() {
                FaceLandmarkerOptions options = this.autoBuild();
                if (options.runningMode() == RunningMode.LIVE_STREAM) {
                    if (!options.resultListener().isPresent()) {
                        throw new IllegalArgumentException("The face landmarker is in the live stream mode, a user-defined result listener must be provided in FaceLandmarkerOptions.");
                    }
                } else if (options.resultListener().isPresent()) {
                    throw new IllegalArgumentException("The face landmarker is in the image or the video mode, a user-defined result listener shouldn't be provided in FaceLandmarkerOptions.");
                }
                return options;
            }
        }
    }
}

