/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.facelandmarker;

import com.google.auto.value.AutoValue;
import com.google.mediapipe.formats.proto.ClassificationProto;
import com.google.mediapipe.formats.proto.LandmarkProto;
import com.google.mediapipe.formats.proto.MatrixDataProto;
import com.google.mediapipe.tasks.components.containers.Category;
import com.google.mediapipe.tasks.components.containers.NormalizedLandmark;
import com.google.mediapipe.tasks.core.TaskResult;
import com.google.mediapipe.tasks.vision.facelandmarker.AutoValue_FaceLandmarkerResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@AutoValue
public abstract class FaceLandmarkerResult
implements TaskResult {
    static FaceLandmarkerResult create(List<LandmarkProto.NormalizedLandmarkList> multiFaceLandmarksProto, Optional<List<ClassificationProto.ClassificationList>> multiFaceBendshapesProto, Optional<List<MatrixDataProto.MatrixData>> multiFaceTransformationMatrixesProto, long timestampMs) {
        ArrayList multiFaceLandmarks = new ArrayList();
        for (LandmarkProto.NormalizedLandmarkList faceLandmarksProto : multiFaceLandmarksProto) {
            ArrayList faceLandmarks = new ArrayList();
            multiFaceLandmarks.add(faceLandmarks);
            for (LandmarkProto.NormalizedLandmark faceLandmarkProto : faceLandmarksProto.getLandmarkList()) {
                faceLandmarks.add(NormalizedLandmark.create((float)faceLandmarkProto.getX(), (float)faceLandmarkProto.getY(), (float)faceLandmarkProto.getZ(), faceLandmarkProto.hasVisibility() ? Optional.of(Float.valueOf(faceLandmarkProto.getVisibility())) : Optional.empty(), faceLandmarkProto.hasPresence() ? Optional.of(Float.valueOf(faceLandmarkProto.getPresence())) : Optional.empty()));
            }
        }
        Optional<List<List<Object>>> multiFaceBlendshapes = Optional.empty();
        if (multiFaceBendshapesProto.isPresent()) {
            ArrayList blendshapes = new ArrayList();
            for (ClassificationProto.ClassificationList faceBendshapeProto : multiFaceBendshapesProto.get()) {
                ArrayList<Category> blendshape = new ArrayList<Category>();
                blendshapes.add(blendshape);
                for (ClassificationProto.Classification classification : faceBendshapeProto.getClassificationList()) {
                    blendshape.add(Category.create((float)classification.getScore(), (int)classification.getIndex(), (String)classification.getLabel(), (String)classification.getDisplayName()));
                }
            }
            multiFaceBlendshapes = Optional.of(Collections.unmodifiableList(blendshapes));
        }
        Optional<List<Object>> multiFaceTransformationMatrixes = Optional.empty();
        if (multiFaceTransformationMatrixesProto.isPresent()) {
            ArrayList<float[]> matrixes = new ArrayList<float[]>();
            for (MatrixDataProto.MatrixData matrixProto : multiFaceTransformationMatrixesProto.get()) {
                if (matrixProto.getPackedDataCount() != 16) {
                    throw new IllegalArgumentException("MatrixData must contain 4x4 matrix as a size 16 float array, but get size " + matrixProto.getPackedDataCount() + " float array.");
                }
                float[] matrixData = new float[matrixProto.getPackedDataCount()];
                for (int i = 0; i < matrixData.length; ++i) {
                    matrixData[i] = matrixProto.getPackedData(i);
                }
                matrixes.add(matrixData);
            }
            multiFaceTransformationMatrixes = Optional.of(Collections.unmodifiableList(matrixes));
        }
        return new AutoValue_FaceLandmarkerResult(timestampMs, Collections.unmodifiableList(multiFaceLandmarks), multiFaceBlendshapes, multiFaceTransformationMatrixes);
    }

    public abstract long timestampMs();

    public abstract List<List<NormalizedLandmark>> faceLandmarks();

    public abstract Optional<List<List<Category>>> faceBlendshapes();

    public abstract Optional<List<float[]>> facialTransformationMatrixes();
}

