/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.imagegenerator;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.mediapipe.calculator.proto.StableDiffusionIterateCalculatorOptionsProto;
import com.google.mediapipe.framework.AndroidPacketGetter;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.PacketGetter;
import com.google.mediapipe.framework.image.BitmapImageBuilder;
import com.google.mediapipe.framework.image.MPImage;
import com.google.mediapipe.tasks.core.BaseOptions;
import com.google.mediapipe.tasks.core.ErrorListener;
import com.google.mediapipe.tasks.core.OutputHandler;
import com.google.mediapipe.tasks.core.TaskInfo;
import com.google.mediapipe.tasks.core.TaskOptions;
import com.google.mediapipe.tasks.core.TaskResult;
import com.google.mediapipe.tasks.core.TaskRunner;
import com.google.mediapipe.tasks.core.proto.ExternalFileProto;
import com.google.mediapipe.tasks.vision.core.BaseVisionTaskApi;
import com.google.mediapipe.tasks.vision.core.RunningMode;
import com.google.mediapipe.tasks.vision.facelandmarker.FaceLandmarker;
import com.google.mediapipe.tasks.vision.facelandmarker.proto.FaceLandmarkerGraphOptionsProto;
import com.google.mediapipe.tasks.vision.imagegenerator.AutoValue_ImageGenerator_ConditionImageResult;
import com.google.mediapipe.tasks.vision.imagegenerator.AutoValue_ImageGenerator_ConditionOptions;
import com.google.mediapipe.tasks.vision.imagegenerator.AutoValue_ImageGenerator_ConditionOptions_DepthConditionOptions;
import com.google.mediapipe.tasks.vision.imagegenerator.AutoValue_ImageGenerator_ConditionOptions_EdgeConditionOptions;
import com.google.mediapipe.tasks.vision.imagegenerator.AutoValue_ImageGenerator_ConditionOptions_FaceConditionOptions;
import com.google.mediapipe.tasks.vision.imagegenerator.AutoValue_ImageGenerator_ImageGeneratorOptions;
import com.google.mediapipe.tasks.vision.imagegenerator.ImageGeneratorResult;
import com.google.mediapipe.tasks.vision.imagegenerator.proto.ConditionedImageGraphOptionsProto;
import com.google.mediapipe.tasks.vision.imagegenerator.proto.ControlPluginGraphOptionsProto;
import com.google.mediapipe.tasks.vision.imagegenerator.proto.ImageGeneratorGraphOptionsProto;
import com.google.mediapipe.tasks.vision.imagesegmenter.ImageSegmenter;
import com.google.mediapipe.tasks.vision.imagesegmenter.proto.ImageSegmenterGraphOptionsProto;
import com.google.protobuf.Any;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ImageGenerator
extends BaseVisionTaskApi {
    private static final String STEPS_STREAM_NAME = "steps";
    private static final String ITERATION_STREAM_NAME = "iteration";
    private static final String PROMPT_STREAM_NAME = "prompt";
    private static final String RAND_SEED_STREAM_NAME = "rand_seed";
    private static final String SOURCE_CONDITION_IMAGE_STREAM_NAME = "source_condition_image";
    private static final String CONDITION_IMAGE_STREAM_NAME = "condition_image";
    private static final String SELECT_STREAM_NAME = "select";
    private static final String SHOW_RESULT_STREAM_NAME = "show_result";
    private static final int GENERATED_IMAGE_OUT_STREAM_INDEX = 0;
    private static final int STEPS_OUT_STREAM_INDEX = 1;
    private static final int ITERATION_OUT_STREAM_INDEX = 2;
    private static final int SHOW_RESULT_OUT_STREAM_INDEX = 3;
    private static final String TASK_GRAPH_NAME = "mediapipe.tasks.vision.image_generator.ImageGeneratorGraph";
    private static final String CONDITION_IMAGE_GRAPHS_CONTAINER_NAME = "mediapipe.tasks.vision.image_generator.ConditionedImageGraphContainer";
    private static final String TAG = "ImageGenerator";
    private static final int GENERATED_IMAGE_WIDTH = 512;
    private static final int GENERATED_IMAGE_HEIGHT = 512;
    private TaskRunner conditionImageGraphsContainerTaskRunner;
    private Map<ConditionOptions.ConditionType, Integer> conditionTypeIndex;
    private boolean useConditionImage = false;
    private CachedInputs cachedInputs = new CachedInputs();
    private boolean inProcessing = false;

    public static ImageGenerator createFromOptions(Context context, ImageGeneratorOptions generatorOptions) {
        return ImageGenerator.createFromOptions(context, generatorOptions, null);
    }

    public static ImageGenerator createFromOptions(Context context, ImageGeneratorOptions generatorOptions, @Nullable ConditionOptions conditionOptions) {
        boolean useConditionImage;
        List<String> inputStreams = new ArrayList<String>();
        inputStreams.addAll(Arrays.asList("STEPS:steps", "ITERATION:iteration", "PROMPT:prompt", "RAND_SEED:rand_seed", "SHOW_RESULT:show_result"));
        boolean bl = useConditionImage = conditionOptions != null;
        if (useConditionImage) {
            inputStreams.add("SELECT:select");
            inputStreams.add("CONDITION_IMAGE:condition_image");
            generatorOptions.conditionOptions = Optional.of(conditionOptions);
        }
        List<String> outputStreams = Arrays.asList("IMAGE:image_out", "STEPS:steps_out", "ITERATION:iteration_out", "SHOW_RESULT:show_result_out");
        OutputHandler handler = new OutputHandler();
        handler.setOutputPacketConverter((OutputHandler.OutputPacketConverter)new OutputHandler.OutputPacketConverter<ImageGeneratorResult, Void>(){

            @Nullable
            public ImageGeneratorResult convertToTaskResult(List<Packet> packets) {
                int iteration = PacketGetter.getInt32((Packet)packets.get(2));
                int steps = PacketGetter.getInt32((Packet)packets.get(1));
                boolean showResult = PacketGetter.getBool((Packet)packets.get(3)) || iteration == steps - 1;
                Log.i((String)ImageGenerator.TAG, (String)("Iteration: " + iteration + ", Steps: " + steps + ", ShowResult: " + showResult));
                if (showResult) {
                    Log.i((String)ImageGenerator.TAG, (String)"processing generated image");
                    Packet packet = packets.get(0);
                    Bitmap generatedBitmap = AndroidPacketGetter.getBitmapFromRgb((Packet)packet);
                    BitmapImageBuilder bitmapImageBuilder = new BitmapImageBuilder(generatedBitmap);
                    return ImageGeneratorResult.create(bitmapImageBuilder.build(), packet.getTimestamp() / 1000L);
                }
                return null;
            }

            public Void convertToTaskInput(List<Packet> packets) {
                return null;
            }
        });
        handler.setHandleTimestampBoundChanges(true);
        generatorOptions.errorListener().ifPresent(arg_0 -> ((OutputHandler)handler).setErrorListener(arg_0));
        TaskRunner runner = TaskRunner.create((Context)context, (TaskInfo)TaskInfo.builder().setTaskName(ImageGenerator.class.getSimpleName()).setTaskRunningModeName(RunningMode.IMAGE.name()).setTaskGraphName(TASK_GRAPH_NAME).setInputStreams(inputStreams).setOutputStreams(outputStreams).setTaskOptions((TaskOptions)generatorOptions).setEnableFlowLimiting(Boolean.valueOf(false)).build(), (OutputHandler)handler);
        ImageGenerator imageGenerator = new ImageGenerator(runner);
        if (useConditionImage) {
            imageGenerator.useConditionImage = true;
            inputStreams = Arrays.asList("IMAGE:source_condition_image", "SELECT:select");
            outputStreams = Arrays.asList("CONDITION_IMAGE:condition_image");
            OutputHandler conditionImageHandler = new OutputHandler();
            conditionImageHandler.setOutputPacketConverter((OutputHandler.OutputPacketConverter)new OutputHandler.OutputPacketConverter<ConditionImageResult, Void>(){

                public ConditionImageResult convertToTaskResult(List<Packet> packets) {
                    Packet packet = packets.get(0);
                    return new AutoValue_ImageGenerator_ConditionImageResult(new BitmapImageBuilder(AndroidPacketGetter.getBitmapFromRgb((Packet)packet)).build(), packet.getTimestamp() / 1000L);
                }

                public Void convertToTaskInput(List<Packet> packets) {
                    return null;
                }
            });
            conditionImageHandler.setHandleTimestampBoundChanges(true);
            imageGenerator.conditionImageGraphsContainerTaskRunner = TaskRunner.create((Context)context, (TaskInfo)TaskInfo.builder().setTaskName(ImageGenerator.class.getSimpleName()).setTaskRunningModeName(RunningMode.IMAGE.name()).setTaskGraphName(CONDITION_IMAGE_GRAPHS_CONTAINER_NAME).setInputStreams(inputStreams).setOutputStreams(outputStreams).setTaskOptions((TaskOptions)generatorOptions).setEnableFlowLimiting(Boolean.valueOf(false)).build(), (OutputHandler)conditionImageHandler);
            imageGenerator.conditionTypeIndex = new HashMap<ConditionOptions.ConditionType, Integer>();
            if (conditionOptions.faceConditionOptions().isPresent()) {
                imageGenerator.conditionTypeIndex.put(ConditionOptions.ConditionType.FACE, imageGenerator.conditionTypeIndex.size());
            }
            if (conditionOptions.edgeConditionOptions().isPresent()) {
                imageGenerator.conditionTypeIndex.put(ConditionOptions.ConditionType.EDGE, imageGenerator.conditionTypeIndex.size());
            }
            if (conditionOptions.depthConditionOptions().isPresent()) {
                imageGenerator.conditionTypeIndex.put(ConditionOptions.ConditionType.DEPTH, imageGenerator.conditionTypeIndex.size());
            }
        }
        return imageGenerator;
    }

    private ImageGenerator(TaskRunner taskRunner) {
        super(taskRunner, RunningMode.IMAGE, "", "");
    }

    public ImageGeneratorResult generate(String prompt, int iterations, int seed) {
        if (this.useConditionImage) {
            throw new IllegalArgumentException("ImageGenerator is created with condition options. Must use the methods with condition options.");
        }
        return this.runIterations(prompt, iterations, seed, null, 0);
    }

    public ImageGeneratorResult generate(String prompt, MPImage sourceConditionImage, ConditionOptions.ConditionType conditionType, int iterations, int seed) {
        if (!this.useConditionImage) {
            throw new IllegalArgumentException("ImageGenerator is created without condition options. Must use the methods without condition options.");
        }
        return this.runIterations(prompt, iterations, seed, this.createConditionImage(sourceConditionImage, conditionType), this.conditionTypeIndex.get((Object)conditionType));
    }

    public void setInputs(String prompt, int iterations, int seed) {
        if (this.useConditionImage) {
            throw new IllegalArgumentException("ImageGenerator is created with condition options. Must use the methods with condition options.");
        }
        this.cachedInputs = new CachedInputs();
        this.cachedInputs.prompt = prompt;
        this.cachedInputs.iterations = iterations;
        this.cachedInputs.seed = seed;
        this.cachedInputs.step = 0;
        this.inProcessing = true;
    }

    public void setInputs(String prompt, MPImage sourceConditionImage, ConditionOptions.ConditionType conditionType, int iterations, int seed) {
        if (!this.useConditionImage) {
            throw new IllegalArgumentException("ImageGenerator is created without condition options. Must use the methods without condition options.");
        }
        this.cachedInputs = new CachedInputs();
        this.cachedInputs.prompt = prompt;
        this.cachedInputs.iterations = iterations;
        this.cachedInputs.seed = seed;
        this.cachedInputs.step = 0;
        this.cachedInputs.cachedConditionImage = this.createConditionImage(sourceConditionImage, conditionType);
        this.cachedInputs.conditionType = conditionType;
        this.inProcessing = true;
    }

    @Nullable
    public ImageGeneratorResult execute(boolean showResult) {
        if (!this.inProcessing) {
            throw new IllegalArgumentException("Must call setInputs before execute.");
        }
        return this.runStep(this.cachedInputs.prompt, this.cachedInputs.iterations, this.cachedInputs.step++, this.cachedInputs.seed, this.cachedInputs.cachedConditionImage, this.useConditionImage ? this.conditionTypeIndex.get((Object)this.cachedInputs.conditionType) : 0, showResult);
    }

    public MPImage createConditionImage(MPImage sourceConditionImage, ConditionOptions.ConditionType conditionType) {
        if (!this.conditionTypeIndex.containsKey((Object)conditionType)) {
            throw new IllegalArgumentException("The condition type " + conditionType.name() + " is not created during initialization.");
        }
        HashMap<String, Packet> inputPackets = new HashMap<String, Packet>();
        inputPackets.put(SOURCE_CONDITION_IMAGE_STREAM_NAME, this.conditionImageGraphsContainerTaskRunner.getPacketCreator().createImage(sourceConditionImage));
        inputPackets.put(SELECT_STREAM_NAME, this.conditionImageGraphsContainerTaskRunner.getPacketCreator().createInt32(this.conditionTypeIndex.get((Object)conditionType).intValue()));
        ConditionImageResult result = (ConditionImageResult)this.conditionImageGraphsContainerTaskRunner.process(inputPackets);
        return result.conditionImage();
    }

    private ImageGeneratorResult runIterations(String prompt, int steps, int seed, @Nullable MPImage conditionImage, int select) {
        if (this.inProcessing) {
            throw new IllegalArgumentException("Iterative API was called previously. It is not allowed to called batch API duringiterative processing.");
        }
        ImageGeneratorResult result = null;
        long timestamp = System.currentTimeMillis() * 1000L;
        for (int i = 0; i < steps; ++i) {
            HashMap<String, Packet> inputPackets = new HashMap<String, Packet>();
            if (i == 0 && this.useConditionImage) {
                inputPackets.put(CONDITION_IMAGE_STREAM_NAME, this.runner.getPacketCreator().createImage(conditionImage));
                inputPackets.put(SELECT_STREAM_NAME, this.runner.getPacketCreator().createInt32(select));
            }
            inputPackets.put(PROMPT_STREAM_NAME, this.runner.getPacketCreator().createString(prompt));
            inputPackets.put(STEPS_STREAM_NAME, this.runner.getPacketCreator().createInt32(steps));
            inputPackets.put(ITERATION_STREAM_NAME, this.runner.getPacketCreator().createInt32(i));
            inputPackets.put(RAND_SEED_STREAM_NAME, this.runner.getPacketCreator().createInt32(seed));
            inputPackets.put(SHOW_RESULT_STREAM_NAME, this.runner.getPacketCreator().createBool(false));
            result = (ImageGeneratorResult)this.runner.process(inputPackets, timestamp++);
        }
        if (this.useConditionImage) {
            return ImageGeneratorResult.create(result.generatedImage(), conditionImage, result.timestampMs());
        }
        return result;
    }

    @Nullable
    private ImageGeneratorResult runStep(String prompt, int iterations, int step, int seed, @Nullable MPImage conditionImage, int select, boolean showResult) {
        if (step == 0) {
            this.cachedInputs.cachedTimestamp = System.currentTimeMillis() * 1000L;
        }
        HashMap<String, Packet> inputPackets = new HashMap<String, Packet>();
        if (step == 0 && this.useConditionImage) {
            inputPackets.put(CONDITION_IMAGE_STREAM_NAME, this.runner.getPacketCreator().createImage(conditionImage));
            inputPackets.put(SELECT_STREAM_NAME, this.runner.getPacketCreator().createInt32(select));
        }
        inputPackets.put(PROMPT_STREAM_NAME, this.runner.getPacketCreator().createString(prompt));
        inputPackets.put(STEPS_STREAM_NAME, this.runner.getPacketCreator().createInt32(iterations));
        inputPackets.put(ITERATION_STREAM_NAME, this.runner.getPacketCreator().createInt32(step));
        inputPackets.put(RAND_SEED_STREAM_NAME, this.runner.getPacketCreator().createInt32(seed));
        inputPackets.put(SHOW_RESULT_STREAM_NAME, this.runner.getPacketCreator().createBool(showResult));
        ImageGeneratorResult result = (ImageGeneratorResult)this.runner.process(inputPackets, this.cachedInputs.cachedTimestamp++);
        if (result != null && this.useConditionImage) {
            result = ImageGeneratorResult.create(result.generatedImage(), conditionImage, result.timestampMs());
        }
        if (step == iterations - 1) {
            this.inProcessing = false;
            this.cachedInputs = new CachedInputs();
        }
        return result;
    }

    @Override
    public void close() {
        if (this.runner != null) {
            this.runner.close();
        }
        if (this.conditionImageGraphsContainerTaskRunner != null) {
            this.conditionImageGraphsContainerTaskRunner.close();
        }
    }

    static {
        System.loadLibrary("mediapipe_tasks_vision_image_generator_jni");
    }

    @AutoValue
    public static abstract class ConditionOptions
    extends TaskOptions {
        abstract Optional<FaceConditionOptions> faceConditionOptions();

        abstract Optional<DepthConditionOptions> depthConditionOptions();

        abstract Optional<EdgeConditionOptions> edgeConditionOptions();

        public static Builder builder() {
            return new AutoValue_ImageGenerator_ConditionOptions.Builder();
        }

        public Any convertToAnyProto() {
            ImageGeneratorGraphOptionsProto.ImageGeneratorGraphOptions.Builder taskOptionsBuilder = ImageGeneratorGraphOptionsProto.ImageGeneratorGraphOptions.newBuilder();
            if (this.faceConditionOptions().isPresent()) {
                taskOptionsBuilder.addControlPluginGraphsOptions((ControlPluginGraphOptionsProto.ControlPluginGraphOptions)ControlPluginGraphOptionsProto.ControlPluginGraphOptions.newBuilder().setBaseOptions(this.convertBaseOptionsToProto(this.faceConditionOptions().get().pluginModelBaseOptions())).setConditionedImageGraphOptions((ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions)ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.newBuilder().setFaceConditionTypeOptions(this.faceConditionOptions().get().convertToProto()).build()).build());
            }
            if (this.edgeConditionOptions().isPresent()) {
                taskOptionsBuilder.addControlPluginGraphsOptions((ControlPluginGraphOptionsProto.ControlPluginGraphOptions)ControlPluginGraphOptionsProto.ControlPluginGraphOptions.newBuilder().setBaseOptions(this.convertBaseOptionsToProto(this.edgeConditionOptions().get().pluginModelBaseOptions())).setConditionedImageGraphOptions((ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions)ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.newBuilder().setEdgeConditionTypeOptions(this.edgeConditionOptions().get().convertToProto()).build()).build());
            }
            if (this.depthConditionOptions().isPresent()) {
                taskOptionsBuilder.addControlPluginGraphsOptions((ControlPluginGraphOptionsProto.ControlPluginGraphOptions)ControlPluginGraphOptionsProto.ControlPluginGraphOptions.newBuilder().setBaseOptions(this.convertBaseOptionsToProto(this.depthConditionOptions().get().pluginModelBaseOptions())).setConditionedImageGraphOptions((ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions)ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.newBuilder().setDepthConditionTypeOptions(this.depthConditionOptions().get().convertToProto()).build()).build());
            }
            return (Any)Any.newBuilder().setTypeUrl("type.googleapis.com/mediapipe.tasks.vision.image_generator.proto.ImageGeneratorGraphOptions").setValue(((ImageGeneratorGraphOptionsProto.ImageGeneratorGraphOptions)taskOptionsBuilder.build()).toByteString()).build();
        }

        @AutoValue
        public static abstract class EdgeConditionOptions {
            abstract BaseOptions pluginModelBaseOptions();

            abstract Float threshold1();

            abstract Float threshold2();

            abstract Integer apertureSize();

            abstract Boolean l2Gradient();

            public static Builder builder() {
                return new AutoValue_ImageGenerator_ConditionOptions_EdgeConditionOptions.Builder().setThreshold1(Float.valueOf(100.0f)).setThreshold2(Float.valueOf(200.0f)).setApertureSize(3).setL2Gradient(false);
            }

            ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.EdgeConditionTypeOptions convertToProto() {
                return (ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.EdgeConditionTypeOptions)ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.EdgeConditionTypeOptions.newBuilder().setThreshold1(this.threshold1().floatValue()).setThreshold2(this.threshold2().floatValue()).setApertureSize(this.apertureSize().intValue()).setL2Gradient(this.l2Gradient().booleanValue()).build();
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setPluginModelBaseOptions(BaseOptions var1);

                public abstract Builder setThreshold1(Float var1);

                public abstract Builder setThreshold2(Float var1);

                public abstract Builder setApertureSize(Integer var1);

                public abstract Builder setL2Gradient(Boolean var1);

                abstract EdgeConditionOptions autoBuild();

                public final EdgeConditionOptions build() {
                    return this.autoBuild();
                }
            }
        }

        @AutoValue
        public static abstract class DepthConditionOptions
        extends TaskOptions {
            abstract BaseOptions pluginModelBaseOptions();

            abstract BaseOptions depthModelBaseOptions();

            public static Builder builder() {
                return new AutoValue_ImageGenerator_ConditionOptions_DepthConditionOptions.Builder();
            }

            ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.DepthConditionTypeOptions convertToProto() {
                ImageSegmenter.ImageSegmenterOptions imageSegmenterOptions = ImageSegmenter.ImageSegmenterOptions.builder().setBaseOptions(this.depthModelBaseOptions()).setOutputConfidenceMasks(true).setOutputCategoryMask(false).setRunningMode(RunningMode.IMAGE).build();
                return (ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.DepthConditionTypeOptions)ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.DepthConditionTypeOptions.newBuilder().setImageSegmenterGraphOptions((ImageSegmenterGraphOptionsProto.ImageSegmenterGraphOptions)imageSegmenterOptions.convertToCalculatorOptionsProto().getExtension((ExtensionLite)ImageSegmenterGraphOptionsProto.ImageSegmenterGraphOptions.ext)).build();
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setPluginModelBaseOptions(BaseOptions var1);

                public abstract Builder setDepthModelBaseOptions(BaseOptions var1);

                abstract DepthConditionOptions autoBuild();

                public final DepthConditionOptions build() {
                    DepthConditionOptions options = this.autoBuild();
                    return options;
                }
            }
        }

        @AutoValue
        public static abstract class FaceConditionOptions
        extends TaskOptions {
            abstract BaseOptions pluginModelBaseOptions();

            abstract BaseOptions faceModelBaseOptions();

            abstract float minFaceDetectionConfidence();

            abstract float minFacePresenceConfidence();

            public static Builder builder() {
                return new AutoValue_ImageGenerator_ConditionOptions_FaceConditionOptions.Builder().setMinFaceDetectionConfidence(0.5f).setMinFacePresenceConfidence(0.5f);
            }

            ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.FaceConditionTypeOptions convertToProto() {
                FaceLandmarker.FaceLandmarkerOptions faceLandmarkerOptions = FaceLandmarker.FaceLandmarkerOptions.builder().setBaseOptions(this.faceModelBaseOptions()).setMinFaceDetectionConfidence(Float.valueOf(this.minFaceDetectionConfidence())).setMinFacePresenceConfidence(Float.valueOf(this.minFacePresenceConfidence())).setRunningMode(RunningMode.IMAGE).setOutputFaceBlendshapes(false).setOutputFacialTransformationMatrixes(false).setNumFaces(1).build();
                return (ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.FaceConditionTypeOptions)ConditionedImageGraphOptionsProto.ConditionedImageGraphOptions.FaceConditionTypeOptions.newBuilder().setFaceLandmarkerGraphOptions((FaceLandmarkerGraphOptionsProto.FaceLandmarkerGraphOptions)faceLandmarkerOptions.convertToCalculatorOptionsProto().getExtension((ExtensionLite)FaceLandmarkerGraphOptionsProto.FaceLandmarkerGraphOptions.ext)).build();
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setPluginModelBaseOptions(BaseOptions var1);

                public abstract Builder setFaceModelBaseOptions(BaseOptions var1);

                public abstract Builder setMinFaceDetectionConfidence(float var1);

                public abstract Builder setMinFacePresenceConfidence(float var1);

                abstract FaceConditionOptions autoBuild();

                public final FaceConditionOptions build() {
                    return this.autoBuild();
                }
            }
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setFaceConditionOptions(FaceConditionOptions var1);

            public abstract Builder setDepthConditionOptions(DepthConditionOptions var1);

            public abstract Builder setEdgeConditionOptions(EdgeConditionOptions var1);

            abstract ConditionOptions autoBuild();

            public final ConditionOptions build() {
                ConditionOptions options = this.autoBuild();
                if (!(options.faceConditionOptions().isPresent() || options.depthConditionOptions().isPresent() || options.edgeConditionOptions().isPresent())) {
                    throw new IllegalArgumentException("At least one of `faceConditionOptions`, `depthConditionOptions` and `edgeConditionOptions` must be set.");
                }
                return options;
            }
        }

        public static enum ConditionType {
            FACE,
            EDGE,
            DEPTH;

        }
    }

    @AutoValue
    public static abstract class ImageGeneratorOptions
    extends TaskOptions {
        private Optional<ConditionOptions> conditionOptions;

        abstract String imageGeneratorModelDirectory();

        abstract Optional<String> loraWeightsFilePath();

        abstract Optional<ErrorListener> errorListener();

        public static Builder builder() {
            return new AutoValue_ImageGenerator_ImageGeneratorOptions.Builder().setImageGeneratorModelDirectory("");
        }

        public Any convertToAnyProto() {
            ImageGeneratorGraphOptionsProto.ImageGeneratorGraphOptions.Builder taskOptionsBuilder = ImageGeneratorGraphOptionsProto.ImageGeneratorGraphOptions.newBuilder();
            if (this.conditionOptions != null && this.conditionOptions.isPresent()) {
                try {
                    taskOptionsBuilder.mergeFrom(this.conditionOptions.get().convertToAnyProto().getValue());
                }
                catch (InvalidProtocolBufferException e) {
                    Log.e((String)ImageGenerator.TAG, (String)("Error converting ConditionOptions to proto. " + e.getMessage()));
                    e.printStackTrace();
                }
            }
            taskOptionsBuilder.setText2ImageModelDirectory(this.imageGeneratorModelDirectory());
            if (this.loraWeightsFilePath().isPresent()) {
                ExternalFileProto.ExternalFile.Builder externalFileBuilder = ExternalFileProto.ExternalFile.newBuilder();
                externalFileBuilder.setFileName(this.loraWeightsFilePath().get());
                taskOptionsBuilder.setLoraWeightsFile((ExternalFileProto.ExternalFile)externalFileBuilder.build());
            }
            taskOptionsBuilder.setStableDiffusionIterateOptions((StableDiffusionIterateCalculatorOptionsProto.StableDiffusionIterateCalculatorOptions)StableDiffusionIterateCalculatorOptionsProto.StableDiffusionIterateCalculatorOptions.newBuilder().setBaseSeed(0).setFileFolder(this.imageGeneratorModelDirectory()).setOutputImageWidth(512).setOutputImageHeight(512).setEmitEmptyPacket(true).setShowEveryNIteration(100).build());
            return (Any)Any.newBuilder().setTypeUrl("type.googleapis.com/mediapipe.tasks.vision.image_generator.proto.ImageGeneratorGraphOptions").setValue(((ImageGeneratorGraphOptionsProto.ImageGeneratorGraphOptions)taskOptionsBuilder.build()).toByteString()).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setImageGeneratorModelDirectory(String var1);

            public abstract Builder setLoraWeightsFilePath(String var1);

            public abstract Builder setErrorListener(ErrorListener var1);

            abstract ImageGeneratorOptions autoBuild();

            public final ImageGeneratorOptions build() {
                return this.autoBuild();
            }
        }
    }

    @AutoValue
    protected static abstract class ConditionImageResult
    implements TaskResult {
        protected ConditionImageResult() {
        }

        public abstract MPImage conditionImage();

        public abstract long timestampMs();
    }

    private static class CachedInputs {
        public String prompt = "";
        public int iterations = 0;
        public int step = 0;
        public int seed = 0;
        public ConditionOptions.ConditionType conditionType;
        public MPImage cachedConditionImage;
        public long cachedTimestamp;

        public final String toString() {
            return "Prompt: " + this.prompt + ", Iterations: " + this.iterations + ", Step: " + this.step + ", Seed: " + this.seed + (this.conditionType == null ? "" : ", ConditionType: " + this.conditionType.name());
        }
    }
}

