/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.tasks.vision.imagesegmenter;

import android.content.Context;
import com.google.auto.value.AutoValue;
import com.google.mediapipe.framework.AndroidPacketGetter;
import com.google.mediapipe.framework.MediaPipeException;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.PacketGetter;
import com.google.mediapipe.framework.image.BitmapImageBuilder;
import com.google.mediapipe.framework.image.ByteBufferImageBuilder;
import com.google.mediapipe.framework.image.MPImage;
import com.google.mediapipe.proto.CalculatorOptionsProto;
import com.google.mediapipe.proto.CalculatorProto;
import com.google.mediapipe.tasks.TensorsToSegmentationCalculatorOptionsProto;
import com.google.mediapipe.tasks.core.BaseOptions;
import com.google.mediapipe.tasks.core.ErrorListener;
import com.google.mediapipe.tasks.core.OutputHandler;
import com.google.mediapipe.tasks.core.TaskInfo;
import com.google.mediapipe.tasks.core.TaskOptions;
import com.google.mediapipe.tasks.core.TaskRunner;
import com.google.mediapipe.tasks.core.proto.BaseOptionsProto;
import com.google.mediapipe.tasks.vision.core.BaseVisionTaskApi;
import com.google.mediapipe.tasks.vision.core.ImageProcessingOptions;
import com.google.mediapipe.tasks.vision.core.RunningMode;
import com.google.mediapipe.tasks.vision.imagesegmenter.AutoValue_ImageSegmenter_ImageSegmenterOptions;
import com.google.mediapipe.tasks.vision.imagesegmenter.AutoValue_ImageSegmenter_SegmentationOptions;
import com.google.mediapipe.tasks.vision.imagesegmenter.ImageSegmenterResult;
import com.google.mediapipe.tasks.vision.imagesegmenter.proto.ImageSegmenterGraphOptionsProto;
import com.google.mediapipe.tasks.vision.imagesegmenter.proto.SegmenterOptionsProto;
import com.google.mediapipe.util.proto.LabelMapProto;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessageLite;
import com.google.protobuf.MessageLite;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public final class ImageSegmenter
extends BaseVisionTaskApi {
    private static final String TAG = ImageSegmenter.class.getSimpleName();
    private static final String IMAGE_IN_STREAM_NAME = "image_in";
    private static final String NORM_RECT_IN_STREAM_NAME = "norm_rect_in";
    private static final String OUTPUT_SIZE_IN_STREAM_NAME = "output_size_in";
    private static final List<String> INPUT_STREAMS = Collections.unmodifiableList(Arrays.asList("IMAGE:image_in", "NORM_RECT:norm_rect_in", "OUTPUT_SIZE:output_size_in"));
    private static final String TASK_GRAPH_NAME = "mediapipe.tasks.vision.image_segmenter.ImageSegmenterGraph";
    private static final String TENSORS_TO_SEGMENTATION_CALCULATOR_NAME = "mediapipe.tasks.TensorsToSegmentationCalculator";
    private boolean hasResultListener = false;
    private List<String> labels = new ArrayList<String>();

    public static ImageSegmenter createFromOptions(Context context, final ImageSegmenterOptions segmenterOptions) {
        if (!segmenterOptions.outputConfidenceMasks() && !segmenterOptions.outputCategoryMask()) {
            throw new IllegalArgumentException("At least one of `outputConfidenceMasks` and `outputCategoryMask` must be set.");
        }
        ArrayList outputStreams = new ArrayList();
        BiFunction<List, String, Integer> getStreamIndex = (streams, streamName) -> {
            streams.add(streamName);
            return streams.size() - 1;
        };
        final int confidenceMasksOutStreamIndex = segmenterOptions.outputConfidenceMasks() ? getStreamIndex.apply(outputStreams, "CONFIDENCE_MASKS:confidence_masks") : -1;
        final int categoryMaskOutStreamIndex = segmenterOptions.outputCategoryMask() ? getStreamIndex.apply(outputStreams, "CATEGORY_MASK:category_mask") : -1;
        final int qualityScoresOutStreamIndex = getStreamIndex.apply(outputStreams, "QUALITY_SCORES:quality_scores");
        final int imageOutStreamIndex = getStreamIndex.apply(outputStreams, "IMAGE:image_out");
        OutputHandler handler = new OutputHandler();
        handler.setOutputPacketConverter((OutputHandler.OutputPacketConverter)new OutputHandler.OutputPacketConverter<ImageSegmenterResult, MPImage>(){

            public ImageSegmenterResult convertToTaskResult(List<Packet> packets) throws MediaPipeException {
                if (packets.get(imageOutStreamIndex).isEmpty()) {
                    return ImageSegmenterResult.create(Optional.empty(), Optional.empty(), new ArrayList<Float>(), packets.get(imageOutStreamIndex).getTimestamp());
                }
                boolean copyImage = !segmenterOptions.resultListener().isPresent();
                Optional<List<MPImage>> confidenceMasks = Optional.empty();
                if (segmenterOptions.outputConfidenceMasks()) {
                    int width = PacketGetter.getImageWidthFromImageList((Packet)packets.get(confidenceMasksOutStreamIndex));
                    int height = PacketGetter.getImageHeightFromImageList((Packet)packets.get(confidenceMasksOutStreamIndex));
                    confidenceMasks = Optional.of(new ArrayList());
                    int confidenceMasksListSize = PacketGetter.getImageListSize((Packet)packets.get(confidenceMasksOutStreamIndex));
                    ByteBuffer[] buffersArray = new ByteBuffer[confidenceMasksListSize];
                    if (copyImage) {
                        for (int i = 0; i < confidenceMasksListSize; ++i) {
                            buffersArray[i] = ByteBuffer.allocateDirect(width * height * 4);
                        }
                    }
                    if (!PacketGetter.getImageList((Packet)packets.get(confidenceMasksOutStreamIndex), (ByteBuffer[])buffersArray, (boolean)copyImage)) {
                        throw new MediaPipeException(MediaPipeException.StatusCode.INTERNAL.ordinal(), "There is an error getting confidence masks.");
                    }
                    ByteBuffer[] i = buffersArray;
                    int n = i.length;
                    for (int j = 0; j < n; ++j) {
                        ByteBuffer buffer = i[j];
                        ByteBufferImageBuilder builder = new ByteBufferImageBuilder(buffer, width, height, 10);
                        confidenceMasks.get().add(builder.build());
                    }
                }
                Optional<MPImage> categoryMask = Optional.empty();
                if (segmenterOptions.outputCategoryMask()) {
                    ByteBuffer buffer;
                    int width = PacketGetter.getImageWidth((Packet)packets.get(categoryMaskOutStreamIndex));
                    int height = PacketGetter.getImageHeight((Packet)packets.get(categoryMaskOutStreamIndex));
                    if (copyImage) {
                        buffer = ByteBuffer.allocateDirect(width * height);
                        if (!PacketGetter.getImageData((Packet)packets.get(categoryMaskOutStreamIndex), (ByteBuffer)buffer)) {
                            throw new MediaPipeException(MediaPipeException.StatusCode.INTERNAL.ordinal(), "There is an error getting category mask.");
                        }
                    } else {
                        buffer = PacketGetter.getImageDataDirectly((Packet)packets.get(categoryMaskOutStreamIndex));
                    }
                    ByteBufferImageBuilder builder = new ByteBufferImageBuilder(buffer, width, height, 8);
                    categoryMask = Optional.of(builder.build());
                }
                float[] qualityScores = PacketGetter.getFloat32Vector((Packet)packets.get(qualityScoresOutStreamIndex));
                ArrayList<Float> qualityScoresList = new ArrayList<Float>(qualityScores.length);
                for (float score : qualityScores) {
                    qualityScoresList.add(Float.valueOf(score));
                }
                return ImageSegmenterResult.create(confidenceMasks, categoryMask, qualityScoresList, BaseVisionTaskApi.generateResultTimestampMs(segmenterOptions.runningMode(), packets.get(imageOutStreamIndex)));
            }

            public MPImage convertToTaskInput(List<Packet> packets) {
                return new BitmapImageBuilder(AndroidPacketGetter.getBitmapFromRgb((Packet)packets.get(imageOutStreamIndex))).build();
            }
        });
        segmenterOptions.resultListener().ifPresent(arg_0 -> ((OutputHandler)handler).setResultListener(arg_0));
        segmenterOptions.errorListener().ifPresent(arg_0 -> ((OutputHandler)handler).setErrorListener(arg_0));
        TaskRunner runner = TaskRunner.create((Context)context, (TaskInfo)TaskInfo.builder().setTaskName(ImageSegmenter.class.getSimpleName()).setTaskRunningModeName(segmenterOptions.runningMode().name()).setTaskGraphName(TASK_GRAPH_NAME).setInputStreams(INPUT_STREAMS).setOutputStreams(outputStreams).setTaskOptions((TaskOptions)segmenterOptions).setEnableFlowLimiting(Boolean.valueOf(segmenterOptions.runningMode() == RunningMode.LIVE_STREAM)).build(), (OutputHandler)handler);
        return new ImageSegmenter(runner, segmenterOptions.runningMode(), segmenterOptions.resultListener().isPresent());
    }

    private ImageSegmenter(TaskRunner taskRunner, RunningMode runningMode, boolean hasResultListener) {
        super(taskRunner, runningMode, IMAGE_IN_STREAM_NAME, NORM_RECT_IN_STREAM_NAME);
        this.hasResultListener = hasResultListener;
        this.populateLabels();
    }

    private void populateLabels() {
        CalculatorProto.CalculatorGraphConfig graphConfig = this.runner.getCalculatorGraphConfig();
        boolean foundTensorsToSegmentation = false;
        for (CalculatorProto.CalculatorGraphConfig.Node node : graphConfig.getNodeList()) {
            if (!node.getName().contains(TENSORS_TO_SEGMENTATION_CALCULATOR_NAME)) continue;
            if (foundTensorsToSegmentation) {
                throw new MediaPipeException(MediaPipeException.StatusCode.INTERNAL.ordinal(), "The graph has more than one mediapipe.tasks.TensorsToSegmentationCalculator.");
            }
            foundTensorsToSegmentation = true;
            TensorsToSegmentationCalculatorOptionsProto.TensorsToSegmentationCalculatorOptions options = (TensorsToSegmentationCalculatorOptionsProto.TensorsToSegmentationCalculatorOptions)node.getOptions().getExtension((ExtensionLite)TensorsToSegmentationCalculatorOptionsProto.TensorsToSegmentationCalculatorOptions.ext);
            for (int i = 0; i < options.getLabelItemsMap().size(); ++i) {
                Long labelKey = i;
                if (!options.getLabelItemsMap().containsKey(labelKey)) {
                    throw new MediaPipeException(MediaPipeException.StatusCode.INTERNAL.ordinal(), "The lablemap have no expected key: " + labelKey);
                }
                this.labels.add(((LabelMapProto.LabelMapItem)options.getLabelItemsMap().get(labelKey)).getName());
            }
        }
    }

    public ImageSegmenterResult segment(MPImage image) {
        return this.segment(image, ImageProcessingOptions.builder().build());
    }

    public ImageSegmenterResult segment(MPImage image, ImageProcessingOptions imageProcessingOptions) {
        return this.segment(image, SegmentationOptions.builder().setOutputWidth(image.getWidth()).setOutputHeight(image.getHeight()).setImageProcessingOptions(imageProcessingOptions).build());
    }

    public ImageSegmenterResult segment(MPImage image, SegmentationOptions segmentationOptions) {
        if (this.hasResultListener) {
            throw new MediaPipeException(MediaPipeException.StatusCode.FAILED_PRECONDITION.ordinal(), "ResultListener is provided in the ImageSegmenterOptions, but this method will return an ImageSegmentationResult.");
        }
        return (ImageSegmenterResult)this.processImageData(this.buildInputPackets(image, segmentationOptions));
    }

    public void segmentWithResultListener(MPImage image) {
        this.segmentWithResultListener(image, ImageProcessingOptions.builder().build());
    }

    public void segmentWithResultListener(MPImage image, ImageProcessingOptions imageProcessingOptions) {
        this.segmentWithResultListener(image, SegmentationOptions.builder().setOutputWidth(image.getWidth()).setOutputHeight(image.getHeight()).setImageProcessingOptions(imageProcessingOptions).build());
    }

    public void segmentWithResultListener(MPImage image, SegmentationOptions segmentationOptions) {
        if (!this.hasResultListener) {
            throw new MediaPipeException(MediaPipeException.StatusCode.FAILED_PRECONDITION.ordinal(), "ResultListener is not set in the ImageSegmenterOptions, but this method expects a ResultListener to process ImageSegmentationResult.");
        }
        ImageSegmenterResult unused = (ImageSegmenterResult)this.processImageData(this.buildInputPackets(image, segmentationOptions));
    }

    public ImageSegmenterResult segmentForVideo(MPImage image, long timestampMs) {
        return this.segmentForVideo(image, ImageProcessingOptions.builder().build(), timestampMs);
    }

    public ImageSegmenterResult segmentForVideo(MPImage image, ImageProcessingOptions imageProcessingOptions, long timestampMs) {
        return this.segmentForVideo(image, SegmentationOptions.builder().setOutputWidth(image.getWidth()).setOutputHeight(image.getHeight()).setImageProcessingOptions(imageProcessingOptions).build(), timestampMs);
    }

    public ImageSegmenterResult segmentForVideo(MPImage image, SegmentationOptions segmentationOptions, long timestampMs) {
        if (this.hasResultListener) {
            throw new MediaPipeException(MediaPipeException.StatusCode.FAILED_PRECONDITION.ordinal(), "ResultListener is provided in the ImageSegmenterOptions, but this method will return an ImageSegmentationResult.");
        }
        return (ImageSegmenterResult)this.processVideoData(this.buildInputPackets(image, segmentationOptions), timestampMs);
    }

    public void segmentForVideoWithResultListener(MPImage image, long timestampMs) {
        this.segmentForVideoWithResultListener(image, ImageProcessingOptions.builder().build(), timestampMs);
    }

    public void segmentForVideoWithResultListener(MPImage image, ImageProcessingOptions imageProcessingOptions, long timestampMs) {
        this.segmentForVideoWithResultListener(image, SegmentationOptions.builder().setOutputWidth(image.getWidth()).setOutputHeight(image.getHeight()).setImageProcessingOptions(imageProcessingOptions).build(), timestampMs);
    }

    public void segmentForVideoWithResultListener(MPImage image, SegmentationOptions segmentationOptions, long timestampMs) {
        if (!this.hasResultListener) {
            throw new MediaPipeException(MediaPipeException.StatusCode.FAILED_PRECONDITION.ordinal(), "ResultListener is not set in the ImageSegmenterOptions, but this method expects a ResultListener to process ImageSegmentationResult.");
        }
        ImageSegmenterResult unused = (ImageSegmenterResult)this.processVideoData(this.buildInputPackets(image, segmentationOptions), timestampMs);
    }

    public void segmentAsync(MPImage image, long timestampMs) {
        this.segmentAsync(image, ImageProcessingOptions.builder().build(), timestampMs);
    }

    public void segmentAsync(MPImage image, ImageProcessingOptions imageProcessingOptions, long timestampMs) {
        this.segmentAsync(image, SegmentationOptions.builder().setOutputWidth(image.getWidth()).setOutputHeight(image.getHeight()).setImageProcessingOptions(imageProcessingOptions).build(), timestampMs);
    }

    public void segmentAsync(MPImage image, SegmentationOptions segmentationOptions, long timestampMs) {
        this.sendLiveStreamData(this.buildInputPackets(image, segmentationOptions), timestampMs);
    }

    public List<String> getLabels() {
        return this.labels;
    }

    private Map<String, Packet> buildInputPackets(MPImage image, SegmentationOptions segmentationOptions) {
        HashMap<String, Packet> inputPackets = new HashMap<String, Packet>();
        inputPackets.put(this.imageStreamName, this.runner.getPacketCreator().createImage(image));
        inputPackets.put(OUTPUT_SIZE_IN_STREAM_NAME, this.runner.getPacketCreator().createInt32Pair(segmentationOptions.outputWidth(), segmentationOptions.outputHeight()));
        if (!this.normRectStreamName.isEmpty()) {
            inputPackets.put(this.normRectStreamName, this.runner.getPacketCreator().createProto((MessageLite)ImageSegmenter.convertToNormalizedRect(segmentationOptions.imageProcessingOptions(), image)));
        }
        return inputPackets;
    }

    static {
        System.loadLibrary("mediapipe_tasks_vision_jni");
    }

    @AutoValue
    public static abstract class ImageSegmenterOptions
    extends TaskOptions {
        abstract BaseOptions baseOptions();

        abstract RunningMode runningMode();

        abstract String displayNamesLocale();

        abstract boolean outputConfidenceMasks();

        abstract boolean outputCategoryMask();

        abstract Optional<OutputHandler.ResultListener<ImageSegmenterResult, MPImage>> resultListener();

        abstract Optional<ErrorListener> errorListener();

        public static Builder builder() {
            return new AutoValue_ImageSegmenter_ImageSegmenterOptions.Builder().setRunningMode(RunningMode.IMAGE).setDisplayNamesLocale("en").setOutputConfidenceMasks(true).setOutputCategoryMask(false);
        }

        public CalculatorOptionsProto.CalculatorOptions convertToCalculatorOptionsProto() {
            ImageSegmenterGraphOptionsProto.ImageSegmenterGraphOptions.Builder taskOptionsBuilder = ImageSegmenterGraphOptionsProto.ImageSegmenterGraphOptions.newBuilder().setBaseOptions((BaseOptionsProto.BaseOptions)((BaseOptionsProto.BaseOptions.Builder)BaseOptionsProto.BaseOptions.newBuilder().setUseStreamMode(this.runningMode() != RunningMode.IMAGE).mergeFrom((GeneratedMessageLite)this.convertBaseOptionsToProto(this.baseOptions()))).build()).setDisplayNamesLocale(this.displayNamesLocale());
            SegmenterOptionsProto.SegmenterOptions.Builder segmenterOptionsBuilder = SegmenterOptionsProto.SegmenterOptions.newBuilder();
            taskOptionsBuilder.setSegmenterOptions(segmenterOptionsBuilder);
            return (CalculatorOptionsProto.CalculatorOptions)((CalculatorOptionsProto.CalculatorOptions.Builder)CalculatorOptionsProto.CalculatorOptions.newBuilder().setExtension((ExtensionLite)ImageSegmenterGraphOptionsProto.ImageSegmenterGraphOptions.ext, (Object)((ImageSegmenterGraphOptionsProto.ImageSegmenterGraphOptions)taskOptionsBuilder.build()))).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setBaseOptions(BaseOptions var1);

            public abstract Builder setRunningMode(RunningMode var1);

            public abstract Builder setDisplayNamesLocale(String var1);

            public abstract Builder setOutputConfidenceMasks(boolean var1);

            public abstract Builder setOutputCategoryMask(boolean var1);

            public abstract Builder setResultListener(OutputHandler.ResultListener<ImageSegmenterResult, MPImage> var1);

            public abstract Builder setErrorListener(ErrorListener var1);

            abstract ImageSegmenterOptions autoBuild();

            public final ImageSegmenterOptions build() {
                ImageSegmenterOptions options = this.autoBuild();
                if (options.runningMode() == RunningMode.LIVE_STREAM && !options.resultListener().isPresent()) {
                    throw new IllegalArgumentException("The image segmenter is in the live stream mode, a user-defined result listener must be provided in ImageSegmenterOptions.");
                }
                return options;
            }
        }
    }

    @AutoValue
    public static abstract class SegmentationOptions {
        abstract int outputWidth();

        abstract int outputHeight();

        abstract ImageProcessingOptions imageProcessingOptions();

        public static Builder builder() {
            return new AutoValue_ImageSegmenter_SegmentationOptions.Builder().setImageProcessingOptions(ImageProcessingOptions.builder().build());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setOutputWidth(int var1);

            public abstract Builder setOutputHeight(int var1);

            public abstract Builder setImageProcessingOptions(ImageProcessingOptions var1);

            abstract SegmentationOptions autoBuild();

            public final SegmentationOptions build() {
                SegmentationOptions options = this.autoBuild();
                if (options.outputWidth() <= 0 || options.outputHeight() <= 0) {
                    throw new IllegalArgumentException("Both outputWidth and outputHeight must be larger than 0.");
                }
                if (options.imageProcessingOptions().regionOfInterest().isPresent()) {
                    throw new IllegalArgumentException("ImageSegmenter doesn't support region-of-interest.");
                }
                return options;
            }
        }
    }
}

