/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;
import com.google.zxing.web.generator.client.TimeZoneInfo;
import com.google.zxing.web.generator.client.TimeZoneList;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CalendarEventGenerator
implements GeneratorSource {
    private static final String[] FULL_DAY_ONLY_IDS = new String[]{"fullDayOnlyInfo1", "fullDayOnlyInfo2", "fullDayOnlyInfo3", "fullDayOnlyInfo4"};
    private static final long ONE_HOUR = 3600000L;
    private Grid table;
    private final TextBox eventName = new TextBox();
    private final CheckBox fullDay = new CheckBox();
    private final DatePicker datePicker1 = new DatePicker();
    private final DatePicker datePicker2 = new DatePicker();
    private final TextBox timePicker1 = new TextBox();
    private final TextBox timePicker2 = new TextBox();
    private final CheckBox summerTime = new CheckBox();
    private final ListBox timeZones = new ListBox();
    private Date timePicker1PreviousDate = null;
    private final TextBox location = new TextBox();
    private final TextBox description = new TextBox();

    public CalendarEventGenerator(ChangeHandler handler, KeyPressHandler keyListener) {
        this.eventName.addStyleName("required");
        this.eventName.addChangeHandler(handler);
        this.eventName.addKeyPressHandler(keyListener);
        CalendarEventGenerator.setDateToTextBox((HasText)this.timePicker1, (Date)new Date());
        try {
            CalendarEventGenerator.setDateToTextBox((HasText)this.timePicker2, (Date)CalendarEventGenerator.addMilliseconds((Date)CalendarEventGenerator.getDateFromTextBox((HasText)this.timePicker1), (long)3600000L));
            this.timePicker1PreviousDate = CalendarEventGenerator.getDateFromTextBox((HasText)this.timePicker1);
        }
        catch (GeneratorException ge) {
            throw new IllegalStateException(ge);
        }
        this.buildTimeZoneList();
        this.timeZones.setSelectedIndex(25);
        this.timeZones.addKeyPressHandler(keyListener);
        this.timePicker1.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.timePicker2.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void buildTimeZoneList() {
        for (TimeZoneInfo info : TimeZoneList.TIMEZONES) {
            this.timeZones.addItem(info.getGmtRelative() + ' ' + info.getAbbreviation(), String.valueOf(info.getGmtDiff()));
        }
    }

    public String getName() {
        return "Calendar event";
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.datePicker1.setValue(new Date());
        this.datePicker2.setValue(new Date());
        this.table = new Grid(10, 2);
        this.table.setText(0, 0, "All day event");
        this.table.setWidget(0, 1, (Widget)this.fullDay);
        this.table.setText(1, 0, "Event title");
        this.table.setWidget(1, 1, (Widget)this.eventName);
        this.table.setText(2, 0, "Start date");
        this.table.setWidget(2, 1, (Widget)this.datePicker1);
        this.table.setText(3, 0, "Time");
        this.table.setWidget(3, 1, (Widget)this.timePicker1);
        this.table.setText(4, 0, "End date");
        this.table.setWidget(4, 1, (Widget)this.datePicker2);
        this.table.setText(5, 0, "Time");
        this.table.setWidget(5, 1, (Widget)this.timePicker2);
        this.table.setText(6, 0, "Time zone");
        this.table.setWidget(6, 1, (Widget)this.timeZones);
        this.table.setText(7, 0, "Daylight savings");
        this.table.setWidget(7, 1, (Widget)this.summerTime);
        this.table.setText(8, 0, "Location");
        this.table.setWidget(8, 1, (Widget)this.location);
        this.table.setText(9, 0, "Description");
        this.table.setWidget(9, 1, (Widget)this.description);
        this.table.getRowFormatter().getElement(3).setId(FULL_DAY_ONLY_IDS[0]);
        this.table.getRowFormatter().getElement(5).setId(FULL_DAY_ONLY_IDS[1]);
        this.table.getRowFormatter().getElement(6).setId(FULL_DAY_ONLY_IDS[2]);
        this.table.getRowFormatter().getElement(7).setId(FULL_DAY_ONLY_IDS[3]);
        this.fullDay.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return this.table;
    }

    public String getText() throws GeneratorException {
        String eventName = this.getEventNameField();
        String dates = this.getDateTimeFields();
        String location = this.getLocationField();
        String description = this.getDescriptionField();
        return "BEGIN:VEVENT\r\n" + eventName + dates + location + description + "END:VEVENT\r\n";
    }

    private String getEventNameField() throws GeneratorException {
        String inputName = this.eventName.getText();
        if (inputName.isEmpty()) {
            throw new GeneratorException("Event name must be at least 1 character.");
        }
        if (inputName.contains("\n")) {
            throw new GeneratorException("Event name should not contain \\n characters.");
        }
        return "SUMMARY:" + inputName + "\r\n";
    }

    private String getDateTimeFields() throws GeneratorException {
        if (this.fullDay.getValue().booleanValue()) {
            return this.getFullDayDateFields();
        }
        return this.getDateTimeValues();
    }

    private String getLocationField() throws GeneratorException {
        String locationString = this.location.getText();
        if (locationString.isEmpty()) {
            return "";
        }
        if (locationString.contains("\n")) {
            throw new GeneratorException("Location should not contain \\n characters.");
        }
        return "LOCATION:" + locationString + "\r\n";
    }

    private String getDescriptionField() throws GeneratorException {
        String descriptionString = this.description.getText();
        if (descriptionString.isEmpty()) {
            return "";
        }
        if (descriptionString.contains("\n")) {
            throw new GeneratorException("Description should not contain \\n characters.");
        }
        return "DESCRIPTION:" + descriptionString + "\r\n";
    }

    private String getFullDayDateFields() throws GeneratorException {
        Date date1 = this.datePicker1.getValue();
        Date date2 = this.datePicker2.getValue();
        if (date1 == null || date2 == null) {
            throw new GeneratorException("Start and end dates must be set.");
        }
        if (date1.after(date2)) {
            throw new GeneratorException("End date cannot be before start date.");
        }
        Date date2PlusDay = new Date(date2.getTime() + 86400000L);
        DateTimeFormat isoFormatter = DateTimeFormat.getFormat((String)"yyyyMMdd");
        return "DTSTART;VALUE=DATE:" + isoFormatter.format(date1) + "\r\nDTEND;VALUE=DATE:" + isoFormatter.format(date2PlusDay) + "\r\n";
    }

    private String getDateTimeValues() throws GeneratorException {
        Date dateTime2;
        Date dateTime1;
        Date date1 = this.datePicker1.getValue();
        Date date2 = this.datePicker2.getValue();
        Date time1 = CalendarEventGenerator.getDateFromTextBox((HasText)this.timePicker1);
        Date time2 = CalendarEventGenerator.getDateFromTextBox((HasText)this.timePicker2);
        if (date1 == null || date2 == null || time1 == null || time2 == null) {
            throw new GeneratorException("Start and end dates/times must be set.");
        }
        String timezoneDelta = this.timeZones.getValue(this.timeZones.getSelectedIndex());
        long diffTimeZone = Long.parseLong(timezoneDelta);
        if (this.summerTime.getValue().booleanValue()) {
            diffTimeZone += 3600000L;
        }
        if ((dateTime1 = CalendarEventGenerator.addMilliseconds((Date)CalendarEventGenerator.mergeDateAndTime((Date)date1, (Date)time1), (long)(-diffTimeZone))).after(dateTime2 = CalendarEventGenerator.addMilliseconds((Date)CalendarEventGenerator.mergeDateAndTime((Date)date2, (Date)time2), (long)(-diffTimeZone)))) {
            throw new GeneratorException("Ending date/time cannot be before starting date/time.");
        }
        DateTimeFormat isoFormatter = DateTimeFormat.getFormat((String)"yyyyMMdd'T'HHmmss'Z'");
        return "DTSTART:" + isoFormatter.format(dateTime1) + "\r\nDTEND:" + isoFormatter.format(dateTime2) + "\r\n";
    }

    private static Date mergeDateAndTime(Date date, Date time) {
        DateTimeFormat extractDate = DateTimeFormat.getFormat((String)"yyyyMMdd");
        DateTimeFormat extractTime = DateTimeFormat.getFormat((String)"HHmm");
        DateTimeFormat merger = DateTimeFormat.getFormat((String)"yyyyMMddHHmmss");
        String d = extractDate.format(date);
        String t = extractTime.format(time) + "00";
        return merger.parse(d + t);
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.eventName) {
            this.getEventNameField();
        } else if (widget == this.datePicker1 || widget == this.timePicker1 || widget == this.datePicker2 || widget == this.timePicker2) {
            this.getDateTimeFields();
        }
    }

    private static Date addMilliseconds(Date time1, long milliseconds) {
        return new Date(time1.getTime() + milliseconds);
    }

    private static Date getDateFromTextBox(HasText textBox) throws GeneratorException {
        DateTimeFormat extractTime = DateTimeFormat.getFormat((String)"HHmm");
        try {
            return extractTime.parseStrict(textBox.getText());
        }
        catch (IllegalArgumentException iae) {
            throw new GeneratorException("Invalid time");
        }
    }

    private static void setDateToTextBox(HasText textBox, Date date) {
        DateTimeFormat extractTime = DateTimeFormat.getFormat((String)"HHmm");
        textBox.setText(extractTime.format(date));
    }

    public void setFocus() {
        this.eventName.setFocus(true);
    }

    static /* synthetic */ Date access$000(CalendarEventGenerator x0) {
        return x0.timePicker1PreviousDate;
    }

    static /* synthetic */ TextBox access$100(CalendarEventGenerator x0) {
        return x0.timePicker1;
    }

    static /* synthetic */ Date access$200(HasText x0) throws GeneratorException {
        return CalendarEventGenerator.getDateFromTextBox((HasText)x0);
    }

    static /* synthetic */ TextBox access$300(CalendarEventGenerator x0) {
        return x0.timePicker2;
    }

    static /* synthetic */ Date access$400(Date x0, long x1) {
        return CalendarEventGenerator.addMilliseconds((Date)x0, (long)x1);
    }

    static /* synthetic */ void access$500(HasText x0, Date x1) {
        CalendarEventGenerator.setDateToTextBox((HasText)x0, (Date)x1);
    }

    static /* synthetic */ Date access$002(CalendarEventGenerator x0, Date x1) {
        x0.timePicker1PreviousDate = x1;
        return x0.timePicker1PreviousDate;
    }

    static /* synthetic */ String[] access$600() {
        return FULL_DAY_ONLY_IDS;
    }
}

