/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;
import com.google.zxing.web.generator.client.Validators;

public final class EmailGenerator
implements GeneratorSource {
    private Grid table;
    private final TextBox email = new TextBox();

    public EmailGenerator(ChangeHandler handler, KeyPressHandler keyListener) {
        this.email.addStyleName("required");
        this.email.addChangeHandler(handler);
        this.email.addKeyPressHandler(keyListener);
    }

    public String getName() {
        return "Email address";
    }

    public String getText() throws GeneratorException {
        return "mailto:" + this.getEmailField();
    }

    private String getEmailField() throws GeneratorException {
        String input = this.email.getText();
        if (input.isEmpty()) {
            throw new GeneratorException("Email must be present.");
        }
        Validators.validateEmail((String)input);
        return input;
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new Grid(1, 2);
        this.table.setText(0, 0, "Address");
        this.table.setWidget(0, 1, (Widget)this.email);
        return this.table;
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.email) {
            this.getEmailField();
        }
    }

    public void setFocus() {
        this.email.setFocus(true);
    }
}

