/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;

public final class GeoLocationGenerator
implements GeneratorSource {
    private static final String LON_REGEXP = "[+-]?[0-9]+(.[0-9]+)?";
    private static final String LAT_REGEXP = "[+-]?[0-9]+(.[0-9]+)?";
    private Grid table;
    private final TextBox latitude = new TextBox();
    private final TextBox longitude = new TextBox();
    private final TextBox query = new TextBox();

    public GeoLocationGenerator(ChangeHandler handler, KeyPressHandler keyListener) {
        this.latitude.addStyleName("required");
        this.latitude.addChangeHandler(handler);
        this.latitude.addKeyPressHandler(keyListener);
        this.longitude.addStyleName("required");
        this.longitude.addChangeHandler(handler);
        this.longitude.addKeyPressHandler(keyListener);
        this.query.addChangeHandler(handler);
        this.query.addKeyPressHandler(keyListener);
    }

    public String getName() {
        return "Geo location";
    }

    public String getText() throws GeneratorException {
        String que = this.getQueryField();
        if (que != null && !que.isEmpty()) {
            if (this.getLatitudeField() == null) {
                this.latitude.setText("0");
            }
            if (this.getLongitudeField() == null) {
                this.longitude.setText("0");
            }
        }
        String lat = this.getLatitudeField();
        String lon = this.getLongitudeField();
        if (que != null && !que.isEmpty()) {
            return "geo:" + lat + ',' + lon + "?q=" + que;
        }
        return "geo:" + lat + ',' + lon;
    }

    private String getQueryField() {
        String que = this.query.getText();
        que = que.replace("&", "%26");
        return que;
    }

    private String getLongitudeField() throws GeneratorException {
        String lon = this.longitude.getText();
        if (!lon.matches("[+-]?[0-9]+(.[0-9]+)?")) {
            throw new GeneratorException("Longitude is not a correct value.");
        }
        double val = Double.parseDouble(lon);
        if (val < -180.0 || val > 180.0) {
            throw new GeneratorException("Longitude must be in [-180:180]");
        }
        return lon;
    }

    private String getLatitudeField() throws GeneratorException {
        String lat = this.latitude.getText();
        if (!lat.matches("[+-]?[0-9]+(.[0-9]+)?")) {
            throw new GeneratorException("Latitude is not a correct value.");
        }
        double val = Double.parseDouble(lat);
        if (val < -90.0 || val > 90.0) {
            throw new GeneratorException("Latitude must be in [-90:90]");
        }
        return lat;
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new Grid(3, 2);
        this.table.setText(0, 0, "Latitude");
        this.table.setWidget(0, 1, (Widget)this.latitude);
        this.table.setText(1, 0, "Longitude");
        this.table.setWidget(1, 1, (Widget)this.longitude);
        this.table.setText(2, 0, "Query");
        this.table.setWidget(2, 1, (Widget)this.query);
        return this.table;
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.latitude) {
            this.getLatitudeField();
        }
        if (widget == this.longitude) {
            this.getLongitudeField();
        }
    }

    public void setFocus() {
        this.latitude.setFocus(true);
    }
}

