/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web.generator.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.zxing.web.generator.client.GeneratorException;
import com.google.zxing.web.generator.client.GeneratorSource;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WifiGenerator
implements GeneratorSource {
    private Grid table;
    private final TextBox ssid = new TextBox();
    private final TextBox password = new TextBox();
    private final ListBox networkType = new ListBox();
    private final CheckBox hidden = new CheckBox();

    public WifiGenerator(ChangeHandler handler, KeyPressHandler keyListener) {
        TextBox[] widgets;
        this.networkType.addItem("WEP", "WEP");
        this.networkType.addItem("WPA/WPA2", "WPA");
        this.networkType.addItem("No encryption", "nopass");
        for (TextBox w : widgets = new TextBox[]{this.ssid, this.password}) {
            w.addChangeHandler(handler);
            w.addKeyPressHandler(keyListener);
        }
    }

    public String getName() {
        return "Wifi network";
    }

    public String getText() throws GeneratorException {
        String ssid = this.getSsidField();
        String password = this.getPasswordField();
        String networkType = this.getNetworkTypeField();
        boolean hidden = this.getHiddenField();
        return WifiGenerator.getWifiString((String)ssid, (String)password, (String)networkType, (boolean)hidden);
    }

    private static String getWifiString(String ssid, String password, String type, boolean hidden) {
        StringBuilder output = new StringBuilder(100);
        output.append("WIFI:");
        output.append("S:").append(ssid).append(';');
        if (type != null && !type.isEmpty() && !"nopass".equals(type)) {
            WifiGenerator.maybeAppend((StringBuilder)output, (String)"T:", (String)type);
        }
        WifiGenerator.maybeAppend((StringBuilder)output, (String)"P:", (String)password);
        if (hidden) {
            WifiGenerator.maybeAppend((StringBuilder)output, (String)"H:", (String)"true");
        }
        output.append(';');
        return output.toString();
    }

    private static void maybeAppend(StringBuilder output, String prefix, String value) {
        if (value != null && !value.isEmpty()) {
            output.append(prefix).append(value).append(';');
        }
    }

    private static String parseTextField(String name, HasText textBox) throws GeneratorException {
        String input = textBox.getText();
        if (input.isEmpty()) {
            return "";
        }
        if (input.contains("\n")) {
            throw new GeneratorException(name + " field must not contain \\n characters.");
        }
        return input.replaceAll("([\\\\:;])", "\\\\$1");
    }

    private String getSsidField() throws GeneratorException {
        String input = this.ssid.getText();
        if (input.isEmpty()) {
            throw new GeneratorException("SSID must be at least 1 character.");
        }
        String parsed = WifiGenerator.parseTextField((String)"SSID", (HasText)this.ssid);
        return WifiGenerator.quoteHex((String)parsed);
    }

    private String getPasswordField() throws GeneratorException {
        return WifiGenerator.parseTextField((String)"Password", (HasText)this.password);
    }

    private String getNetworkTypeField() {
        return this.networkType.getValue(this.networkType.getSelectedIndex());
    }

    private boolean getHiddenField() {
        Boolean value = this.hidden.getValue();
        return value != null && value != false;
    }

    public Grid getWidget() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new Grid(4, 2);
        this.table.setText(0, 0, "SSID");
        this.table.setWidget(0, 1, (Widget)this.ssid);
        this.table.setText(1, 0, "Password");
        this.table.setWidget(1, 1, (Widget)this.password);
        this.table.setText(2, 0, "Network Type");
        this.table.setWidget(2, 1, (Widget)this.networkType);
        this.table.setText(3, 0, "Hidden?");
        this.table.setWidget(3, 1, (Widget)this.hidden);
        this.ssid.addStyleName("required");
        return this.table;
    }

    public void validate(Widget widget) throws GeneratorException {
        if (widget == this.ssid) {
            this.getSsidField();
        }
        if (widget == this.password) {
            this.getPasswordField();
        }
        if (widget == this.networkType) {
            this.getNetworkTypeField();
        }
        if (widget == this.hidden) {
            this.getHiddenField();
        }
    }

    public void setFocus() {
        this.ssid.setFocus(true);
    }

    private static String quoteHex(String value) {
        if (value != null && value.matches("[0-9A-Fa-f]+")) {
            if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                return value;
            }
            return '\"' + value + '\"';
        }
        return value;
    }
}

