/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.aidl;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.hiservice.aidl.UtteranceProgressCallback;
import java.util.ArrayList;
import java.util.List;

public interface HiServiceInterface
extends IInterface {
    public static final String APP_KEY = "app_key";
    public static final String APP_SECRET = "app_secret";
    public static final String EXTRA_TRANSLATE_STATE = "translate_state";
    public static final String EXTRA_TRANSLATE_SUCCESS_TRANSLATION = "translate_success_translation";
    public static final String EXTRA_TRANSLATE_FAILURE_MESSAGE = "translate_failure_message";
    public static final String EXTRA_TRANSLATE_SUCCESS_SOURCE_LANGUAGE = "translate_success_source_language";
    public static final int TRANSLATE_STATE_SUCCESS = 0;
    public static final int TRANSLATE_STATE_FAILURE = 1;
    public static final String EXTRA_LANGUAGE_ID_STATE = "language_id_state";
    public static final String EXTRA_LANGUAGE_ID_SUCCESS_LANGUAGE = "language_id_success_language";
    public static final String EXTRA_LANGUAGE_ID_FAILURE_MESSAGE = "language_id_failure_message";
    public static final int LANGUAGE_ID_STATE_SUCCESS = 0;
    public static final int LANGUAGE_ID_STATE_FAILURE = 1;
    public static final String EXTRA_ROTATION = "extra_rotation";
    public static final String EXTRA_BITMAP = "extra_bitmap";
    public static final String EXTRA_SOURCE_LANGUAGE = "extra_source_language";
    public static final String EXTRA_VISION_CODE = "extra_vision_code";
    public static final String EXTRA_VISION_MSG = "extra_vision_msg";
    public static final String EXTRA_VISION_RESULT = "extra_vision_result";

    public Bundle translate(String var1, String var2, String var3) throws RemoteException;

    public Bundle multiTranslate(List<String> var1, String var2, String var3) throws RemoteException;

    public Bundle languageIdentify(String var1) throws RemoteException;

    public boolean isLanguageAvailable(String var1) throws RemoteException;

    public boolean isSpeaking() throws RemoteException;

    public boolean speak(String var1, String var2) throws RemoteException;

    public boolean stopSpeak() throws RemoteException;

    public void registerUtteranceProgress(UtteranceProgressCallback var1) throws RemoteException;

    public void unregisterUtteranceProgress(UtteranceProgressCallback var1) throws RemoteException;

    public Bundle doOcrOnly(Bundle var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements HiServiceInterface {
        private static final String DESCRIPTOR = "com.hiservice.aidl.HiServiceInterface";
        static final int TRANSACTION_translate = 1;
        static final int TRANSACTION_multiTranslate = 2;
        static final int TRANSACTION_languageIdentify = 3;
        static final int TRANSACTION_isLanguageAvailable = 4;
        static final int TRANSACTION_isSpeaking = 5;
        static final int TRANSACTION_speak = 6;
        static final int TRANSACTION_stopSpeak = 7;
        static final int TRANSACTION_registerUtteranceProgress = 8;
        static final int TRANSACTION_unregisterUtteranceProgress = 9;
        static final int TRANSACTION_doOcrOnly = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static HiServiceInterface asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof HiServiceInterface) {
                return (HiServiceInterface)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    Bundle _result = this.translate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ArrayList _arg0 = data.createStringArrayList();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    Bundle _result = this.multiTranslate(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Bundle _result = this.languageIdentify(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isLanguageAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isSpeaking();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.speak(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.stopSpeak();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    UtteranceProgressCallback _arg0 = UtteranceProgressCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerUtteranceProgress(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    UtteranceProgressCallback _arg0 = UtteranceProgressCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterUtteranceProgress(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    Bundle _result = this.doOcrOnly(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(HiServiceInterface impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static HiServiceInterface getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements HiServiceInterface {
            private IBinder mRemote;
            public static HiServiceInterface sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle translate(String text, String sourceLanguage, String targetLanguage) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(text);
                    _data.writeString(sourceLanguage);
                    _data.writeString(targetLanguage);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bundle bundle = Stub.getDefaultImpl().translate(text, sourceLanguage, targetLanguage);
                        return bundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle multiTranslate(List<String> texts, String sourceLanguage, String targetLanguage) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(texts);
                    _data.writeString(sourceLanguage);
                    _data.writeString(targetLanguage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bundle bundle = Stub.getDefaultImpl().multiTranslate(texts, sourceLanguage, targetLanguage);
                        return bundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle languageIdentify(String text) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(text);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bundle bundle = Stub.getDefaultImpl().languageIdentify(text);
                        return bundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLanguageAvailable(String language) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(language);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isLanguageAvailable(language);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSpeaking() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isSpeaking();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean speak(String text, String language) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(text);
                    _data.writeString(language);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().speak(text, language);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopSpeak() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().stopSpeak();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerUtteranceProgress(UtteranceProgressCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerUtteranceProgress(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUtteranceProgress(UtteranceProgressCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterUtteranceProgress(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle doOcrOnly(Bundle bitmap) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bitmap != null) {
                        _data.writeInt(1);
                        bitmap.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Bundle bundle = Stub.getDefaultImpl().doOcrOnly(bitmap);
                        return bundle;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements HiServiceInterface {
        @Override
        public Bundle translate(String text, String sourceLanguage, String targetLanguage) throws RemoteException {
            return null;
        }

        @Override
        public Bundle multiTranslate(List<String> texts, String sourceLanguage, String targetLanguage) throws RemoteException {
            return null;
        }

        @Override
        public Bundle languageIdentify(String text) throws RemoteException {
            return null;
        }

        @Override
        public boolean isLanguageAvailable(String language) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSpeaking() throws RemoteException {
            return false;
        }

        @Override
        public boolean speak(String text, String language) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopSpeak() throws RemoteException {
            return false;
        }

        @Override
        public void registerUtteranceProgress(UtteranceProgressCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterUtteranceProgress(UtteranceProgressCallback callback) throws RemoteException {
        }

        @Override
        public Bundle doOcrOnly(Bundle bitmap) throws RemoteException {
            return null;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

