/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate;

import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.WorkerThread;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper;", "", "context", "Landroid/content/Context;", "listener", "Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;", "(Landroid/content/Context;Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;)V", "languageModeMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "downloadLanguageMode", "", "languageCode", "isFileDownloaded", "", "url", "unzipFile", "zipFile", "Ljava/io/File;", "targetDirectory", "Companion", "DownloadListener", "fun-translate_release"})
@Keep
public final class LanguageModelDownloadHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final DownloadListener listener;
    @NotNull
    private final HashMap<String, String> languageModeMap;
    public static final long TIME_OUT = 30L;
    @NotNull
    public static final String LANGUAGE_MODE_PATH = "com.google.mlkit.translate.models";
    @NotNull
    public static final String FILE_NAME = "language_model.zip";

    public LanguageModelDownloadHelper(@NotNull Context context, @NotNull DownloadListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.context = context;
        this.listener = listener;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"af", (Object)"https://support.igofun.mobi/offline_translate/af_en.zip"), TuplesKt.to((Object)"ar", (Object)"https://support.igofun.mobi/offline_translate/ar_en.zip"), TuplesKt.to((Object)"be", (Object)"https://support.igofun.mobi/offline_translate/be_en.zip"), TuplesKt.to((Object)"bg", (Object)"https://support.igofun.mobi/offline_translate/bg_en.zip"), TuplesKt.to((Object)"bn", (Object)"https://support.igofun.mobi/offline_translate/bn_en.zip"), TuplesKt.to((Object)"ca", (Object)"https://support.igofun.mobi/offline_translate/ca_en.zip"), TuplesKt.to((Object)"cs", (Object)"https://support.igofun.mobi/offline_translate/cs_en.zip"), TuplesKt.to((Object)"cy", (Object)"https://support.igofun.mobi/offline_translate/cy_en.zip"), TuplesKt.to((Object)"da", (Object)"https://support.igofun.mobi/offline_translate/da_en.zip"), TuplesKt.to((Object)"de", (Object)"https://support.igofun.mobi/offline_translate/de_en.zip"), TuplesKt.to((Object)"el", (Object)"https://support.igofun.mobi/offline_translate/el_en.zip"), TuplesKt.to((Object)"eo", (Object)"https://support.igofun.mobi/offline_translate/en_eo.zip"), TuplesKt.to((Object)"es", (Object)"https://support.igofun.mobi/offline_translate/en_es.zip"), TuplesKt.to((Object)"et", (Object)"https://support.igofun.mobi/offline_translate/en_et.zip"), TuplesKt.to((Object)"fa", (Object)"https://support.igofun.mobi/offline_translate/en_fa.zip"), TuplesKt.to((Object)"fi", (Object)"https://support.igofun.mobi/offline_translate/en_fi.zip"), TuplesKt.to((Object)"fr", (Object)"https://support.igofun.mobi/offline_translate/en_fr.zip"), TuplesKt.to((Object)"ga", (Object)"https://support.igofun.mobi/offline_translate/en_ga.zip"), TuplesKt.to((Object)"gl", (Object)"https://support.igofun.mobi/offline_translate/en_gl.zip"), TuplesKt.to((Object)"gu", (Object)"https://support.igofun.mobi/offline_translate/en_gu.zip"), TuplesKt.to((Object)"he", (Object)"https://support.igofun.mobi/offline_translate/en_hi.zip"), TuplesKt.to((Object)"hi", (Object)"https://support.igofun.mobi/offline_translate/en_hr.zip"), TuplesKt.to((Object)"hr", (Object)"https://support.igofun.mobi/offline_translate/en_ht.zip"), TuplesKt.to((Object)"ht", (Object)"https://support.igofun.mobi/offline_translate/en_hu.zip"), TuplesKt.to((Object)"hu", (Object)"https://support.igofun.mobi/offline_translate/en_id.zip"), TuplesKt.to((Object)"id", (Object)"https://support.igofun.mobi/offline_translate/en_is.zip"), TuplesKt.to((Object)"is", (Object)"https://support.igofun.mobi/offline_translate/en_it.zip"), TuplesKt.to((Object)"it", (Object)"https://support.igofun.mobi/offline_translate/en_iw.zip"), TuplesKt.to((Object)"ja", (Object)"https://support.igofun.mobi/offline_translate/en_ja.zip"), TuplesKt.to((Object)"ka", (Object)"https://support.igofun.mobi/offline_translate/en_ka.zip"), TuplesKt.to((Object)"kn", (Object)"https://support.igofun.mobi/offline_translate/en_kn.zip"), TuplesKt.to((Object)"ko", (Object)"https://support.igofun.mobi/offline_translate/en_ko.zip"), TuplesKt.to((Object)"lt", (Object)"https://support.igofun.mobi/offline_translate/en_lt.zip"), TuplesKt.to((Object)"lv", (Object)"https://support.igofun.mobi/offline_translate/en_lv.zip"), TuplesKt.to((Object)"mk", (Object)"https://support.igofun.mobi/offline_translate/en_mk.zip"), TuplesKt.to((Object)"mr", (Object)"https://support.igofun.mobi/offline_translate/en_mr.zip"), TuplesKt.to((Object)"ms", (Object)"https://support.igofun.mobi/offline_translate/en_ms.zip"), TuplesKt.to((Object)"mt", (Object)"https://support.igofun.mobi/offline_translate/en_mt.zip"), TuplesKt.to((Object)"nl", (Object)"https://support.igofun.mobi/offline_translate/en_nl.zip"), TuplesKt.to((Object)"no", (Object)"https://support.igofun.mobi/offline_translate/en_no.zip"), TuplesKt.to((Object)"pl", (Object)"https://support.igofun.mobi/offline_translate/en_pl.zip"), TuplesKt.to((Object)"pt", (Object)"https://support.igofun.mobi/offline_translate/en_pt.zip"), TuplesKt.to((Object)"ro", (Object)"https://support.igofun.mobi/offline_translate/en_ro.zip"), TuplesKt.to((Object)"ru", (Object)"https://support.igofun.mobi/offline_translate/en_ru.zip"), TuplesKt.to((Object)"sk", (Object)"https://support.igofun.mobi/offline_translate/en_sk.zip"), TuplesKt.to((Object)"sl", (Object)"https://support.igofun.mobi/offline_translate/en_sl.zip"), TuplesKt.to((Object)"sq", (Object)"https://support.igofun.mobi/offline_translate/en_sq.zip"), TuplesKt.to((Object)"sv", (Object)"https://support.igofun.mobi/offline_translate/en_sv.zip"), TuplesKt.to((Object)"sw", (Object)"https://support.igofun.mobi/offline_translate/en_sw.zip"), TuplesKt.to((Object)"ta", (Object)"https://support.igofun.mobi/offline_translate/en_ta.zip"), TuplesKt.to((Object)"te", (Object)"https://support.igofun.mobi/offline_translate/en_te.zip"), TuplesKt.to((Object)"th", (Object)"https://support.igofun.mobi/offline_translate/en_th.zip"), TuplesKt.to((Object)"tl", (Object)"https://support.igofun.mobi/offline_translate/en_tl.zip"), TuplesKt.to((Object)"tr", (Object)"https://support.igofun.mobi/offline_translate/en_tr.zip"), TuplesKt.to((Object)"uk", (Object)"https://support.igofun.mobi/offline_translate/en_uk.zip"), TuplesKt.to((Object)"ur", (Object)"https://support.igofun.mobi/offline_translate/en_ur.zip"), TuplesKt.to((Object)"vi", (Object)"https://support.igofun.mobi/offline_translate/en_vi.zip"), TuplesKt.to((Object)"zh", (Object)"https://support.igofun.mobi/offline_translate/en_zh.zip")};
        this.languageModeMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @WorkerThread
    public final void downloadLanguageMode(@NotNull String languageCode) {
        String url;
        Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
        String string = this.languageModeMap.get(languageCode);
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(url = string)).length() == 0) {
            this.listener.onError(new Exception("Can't find download url"), url);
            return;
        }
        if (this.isFileDownloaded(url)) {
            this.listener.onError(new Exception("Already download url"), url);
            return;
        }
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).build();
        this.listener.onStartDownload(url);
        client.newCall(request).enqueue(new Callback(this, url){
            final /* synthetic */ LanguageModelDownloadHelper this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(e, this.$url);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                InputStream inputStream;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(new IOException("Unexpected code " + response), this.$url);
                    return;
                }
                File noBackupDir = new File(LanguageModelDownloadHelper.access$getContext$p(this.this$0).getNoBackupFilesDir(), "com.google.mlkit.translate.models");
                if (!noBackupDir.exists()) {
                    noBackupDir.mkdirs();
                }
                File file = new File(noBackupDir, "language_model.zip");
                InputStream inputStream2 = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream2 = response.body().byteStream();
                    outputStream = new FileOutputStream(file);
                    byte[] buffer = new byte[2048];
                    int bytesRead = 0;
                    long totalSize = response.body().contentLength();
                    long downloadedSize = 0L;
                    InputStream inputStream3 = inputStream2;
                    LanguageModelDownloadHelper languageModelDownloadHelper = this.this$0;
                    String string = this.$url;
                    InputStream it = inputStream3;
                    boolean bl = false;
                    while (true) {
                        int n;
                        int it2 = n = it.read(buffer);
                        boolean bl2 = false;
                        bytesRead = it2;
                        if (n == -1) break;
                        outputStream.write(buffer, 0, bytesRead);
                        downloadedSize += (long)bytesRead;
                        if (totalSize <= 0L) continue;
                        int progress = (int)(downloadedSize * (long)100 / totalSize);
                        LanguageModelDownloadHelper.access$getListener$p(languageModelDownloadHelper).onProgressUpdate(progress, string);
                    }
                    outputStream.flush();
                    LanguageModelDownloadHelper.access$unzipFile(languageModelDownloadHelper, file, noBackupDir);
                    LanguageModelDownloadHelper.access$getListener$p(languageModelDownloadHelper).onDownloadComplete(file, string);
                    file.delete();
                    inputStream = inputStream2;
                }
                catch (Exception e) {
                    InputStream inputStream4;
                    try {
                        LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(e, this.$url);
                        inputStream4 = inputStream2;
                    }
                    catch (Throwable throwable) {
                        InputStream inputStream5 = inputStream2;
                        if (inputStream5 != null) {
                            inputStream5.close();
                        }
                        FileOutputStream fileOutputStream = outputStream;
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        throw throwable;
                    }
                    if (inputStream4 != null) {
                        inputStream4.close();
                    }
                    FileOutputStream fileOutputStream = outputStream;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                outputStream.close();
            }
        });
    }

    private final boolean isFileDownloaded(String url) {
        String folderPath = this.context.getNoBackupFilesDir() + "/com.google.mlkit.translate.models";
        String fileName = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null), (String)".", null, (int)2, null);
        String filePath = folderPath + '/' + fileName;
        File file = new File(filePath);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void unzipFile(File zipFile, File targetDirectory) throws IOException {
        var3_3 = new ZipInputStream(new FileInputStream(zipFile));
        var4_4 = null;
        try {
            zis = (ZipInputStream)var3_3;
            $i$a$-use-LanguageModelDownloadHelper$unzipFile$1 = false;
            zipEntry = null;
            buffer = new byte[1024];
            while (true) lbl-1000:
            // 4 sources

            {
                it = var9_11 = zis.getNextEntry();
                $i$a$-also-LanguageModelDownloadHelper$unzipFile$1$1 = false;
                zipEntry = it;
                if (var9_11 == null) ** break;
                v0 = zipEntry;
                Intrinsics.checkNotNull((Object)v0);
                newFile = new File(targetDirectory, v0.getName());
                if (zipEntry.isDirectory()) {
                    if (newFile.isDirectory() || newFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory " + newFile.getAbsolutePath());
                }
                parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent.getAbsolutePath());
                }
                var11_14 = new FileOutputStream(newFile);
                var12_15 = null;
                try {
                    fos = (FileOutputStream)var11_14;
                    $i$a$-use-LanguageModelDownloadHelper$unzipFile$1$2 = false;
                    len = 0;
                    while (true) {
                        it = var16_21 = zis.read(buffer);
                        $i$a$-also-LanguageModelDownloadHelper$unzipFile$1$2$1 = false;
                        len = it;
                        if (var16_21 <= 0) break;
                        fos.write(buffer, 0, len);
                    }
                    var13_16 = Unit.INSTANCE;
                }
                catch (Throwable var13_17) {
                    var12_15 = var13_17;
                    throw var13_17;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var11_14, (Throwable)var12_15);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            var5_5 = Unit.INSTANCE;
        }
        catch (Throwable var5_6) {
            var4_4 = var5_6;
            throw var5_6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var3_3, (Throwable)var4_4);
        }
    }

    public static final /* synthetic */ DownloadListener access$getListener$p(LanguageModelDownloadHelper $this) {
        return $this.listener;
    }

    public static final /* synthetic */ Context access$getContext$p(LanguageModelDownloadHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$unzipFile(LanguageModelDownloadHelper $this, File zipFile, File targetDirectory) {
        $this.unzipFile(zipFile, targetDirectory);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper$Companion;", "", "()V", "FILE_NAME", "", "LANGUAGE_MODE_PATH", "TIME_OUT", "", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001c\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u0010"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;", "", "onDownloadComplete", "", "file", "Ljava/io/File;", "url", "", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onProgressUpdate", "percentage", "", "onStartDownload", "fun-translate_release"})
    public static interface DownloadListener {
        public void onStartDownload(@NotNull String var1);

        public void onProgressUpdate(int var1, @NotNull String var2);

        public void onDownloadComplete(@NotNull File var1, @NotNull String var2);

        public void onError(@NotNull Exception var1, @NotNull String var2);
    }
}

