/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate.offline;

import android.os.Build;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.google.mlkit.common.model.DownloadConditions;
import com.google.mlkit.common.model.RemoteModel;
import com.google.mlkit.common.model.RemoteModelManager;
import com.google.mlkit.nl.translate.TranslateLanguage;
import com.google.mlkit.nl.translate.TranslateRemoteModel;
import com.google.mlkit.nl.translate.Translation;
import com.google.mlkit.nl.translate.Translator;
import com.google.mlkit.nl.translate.TranslatorOptions;
import com.hiservice.translate.offline.IDownloadCallback;
import com.hiservice.translate.offline.IDownloadStatusCallback;
import com.hiservice.translate.offline.IOfflineTranslate;
import com.hiservice.translate.offline.ITranslateCallback;
import com.hiservice.translate.offline.LanguageTagErrorException;
import com.hiservice.translate.offline.ParamDownload;
import com.hiservice.translate.offline.ParamModel;
import com.hiservice.translate.offline.ParamTranslateText;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0017J*\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J$\u0010\u0018\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001a\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0012\u001a\u0004\u0018\u00010!H\u0016J,\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/hiservice/translate/offline/OfflineTranslate;", "Lcom/hiservice/translate/offline/IOfflineTranslate;", "DBG", "", "count", "", "(ZI)V", "clientMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/google/mlkit/nl/translate/Translator;", "allLanguageTags", "", "destroy", "", "downloadMode", "paramDownload", "Lcom/hiservice/translate/offline/ParamDownload;", "callback", "Lcom/hiservice/translate/offline/IDownloadCallback;", "downloadModeImpl", "languageTag", "requireWifi", "requireCharging", "ensureMapSizeLimit", "maxSize", "isDownloadedMode", "paramModel", "Lcom/hiservice/translate/offline/ParamModel;", "Lcom/hiservice/translate/offline/IDownloadStatusCallback;", "translate", "paramTranslateText", "Lcom/hiservice/translate/offline/ParamTranslateText;", "Lcom/hiservice/translate/offline/ITranslateCallback;", "text", "fromCode", "toCode", "Companion", "fun-translate_release"})
public final class OfflineTranslate
implements IOfflineTranslate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean DBG;
    private final int count;
    @NotNull
    private final ConcurrentHashMap<String, Translator> clientMap;
    @NotNull
    private static final String TAG = "OfflineTranslate";

    public OfflineTranslate(boolean DBG, int count) {
        this.DBG = DBG;
        this.count = count;
        this.clientMap = new ConcurrentHashMap();
    }

    public /* synthetic */ OfflineTranslate(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(bl, n);
    }

    @Override
    @WorkerThread
    public void downloadMode(@NotNull ParamDownload paramDownload, @Nullable IDownloadCallback callback) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)paramDownload, (String)"paramDownload");
            try {
                String languageTag = paramDownload.getLanguageTag();
                boolean requireWifi = paramDownload.getRequireWifi();
                boolean requireCharging = paramDownload.getRequireCharging();
                this.downloadModeImpl(languageTag, requireWifi, requireCharging, callback);
            }
            catch (Exception e) {
                e.printStackTrace();
                IDownloadCallback iDownloadCallback = callback;
                if (iDownloadCallback == null) break block3;
                String string = paramDownload.getLanguageTag();
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "-1";
                }
                iDownloadCallback.downloadFailed(string, string2);
            }
        }
    }

    @Override
    public void translate(@NotNull ParamTranslateText paramTranslateText, @Nullable ITranslateCallback callback) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)paramTranslateText, (String)"paramTranslateText");
            try {
                this.translate(paramTranslateText.getText(), paramTranslateText.getFromLanguageCode(), paramTranslateText.getToLanguageCode(), callback);
            }
            catch (Exception e) {
                e.printStackTrace();
                ITranslateCallback iTranslateCallback = callback;
                if (iTranslateCallback == null) break block3;
                String string = paramTranslateText.getText();
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "-2";
                }
                iTranslateCallback.translateFailed(string, string2);
            }
        }
    }

    @Override
    @NotNull
    public List<String> allLanguageTags() {
        List list = TranslateLanguage.getAllLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllLanguages()");
        return list;
    }

    @Override
    public void isDownloadedMode(@NotNull ParamModel paramModel, @Nullable IDownloadStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)paramModel, (String)"paramModel");
        String string = TranslateLanguage.fromLanguageTag((String)paramModel.getLanguageTag());
        if (string == null) {
            boolean bl = false;
            String msg = "error languageTag:" + paramModel + ".languageTag";
            Log.e((String)TAG, (String)msg);
            throw new LanguageTagErrorException(msg);
        }
        String languageTag = string;
        TranslateRemoteModel translateRemoteModel = new TranslateRemoteModel.Builder(languageTag).build();
        Intrinsics.checkNotNullExpressionValue((Object)translateRemoteModel, (String)"Builder(languageTag).build()");
        TranslateRemoteModel translateMode = translateRemoteModel;
        RemoteModelManager remoteModelManager = RemoteModelManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)remoteModelManager, (String)"getInstance()");
        RemoteModelManager modelManager = remoteModelManager;
        modelManager.isModelDownloaded((RemoteModel)translateMode).addOnSuccessListener(arg_0 -> OfflineTranslate.isDownloadedMode$lambda-1(callback, arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.isDownloadedMode$lambda-2(callback, arg_0));
    }

    @Override
    public void destroy() {
        try {
            Map $this$forEach$iv = this.clientMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Translator translator = (Translator)entry.getValue();
                try {
                    translator.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.clientMap.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void translate(String text, String fromCode, String toCode, ITranslateCallback callback) {
        String key = fromCode + toCode;
        Translator translator = this.clientMap.get(key);
        if (translator == null) {
            TranslatorOptions translatorOptions = new TranslatorOptions.Builder().setSourceLanguage(fromCode).setTargetLanguage(toCode).build();
            Intrinsics.checkNotNullExpressionValue((Object)translatorOptions, (String)"Builder()\n              \u2026\n                .build()");
            TranslatorOptions options = translatorOptions;
            translator = Translation.getClient((TranslatorOptions)options);
            this.ensureMapSizeLimit(this.clientMap, Math.max(this.count - 1, 0));
            ((Map)this.clientMap).put(key, translator);
        }
        if (this.DBG) {
            Log.i((String)TAG, (String)("offline translate " + fromCode + " - " + toCode + ", txt:" + text));
        }
        translator.translate(text).addOnSuccessListener(arg_0 -> OfflineTranslate.translate$lambda-4(this, text, callback, arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.translate$lambda-5(this, callback, text, arg_0));
    }

    static /* synthetic */ void translate$default(OfflineTranslate offlineTranslate, String string, String string2, String string3, ITranslateCallback iTranslateCallback, int n, Object object) {
        if ((n & 8) != 0) {
            iTranslateCallback = null;
        }
        offlineTranslate.translate(string, string2, string3, iTranslateCallback);
    }

    private final void downloadModeImpl(String languageTag, boolean requireWifi, boolean requireCharging, IDownloadCallback callback) {
        Log.v((String)TAG, (String)("start download offline translate mode: " + languageTag + ", requireWifi:" + requireWifi + ", requireCharging:" + requireCharging));
        String string = TranslateLanguage.fromLanguageTag((String)languageTag);
        if (string == null) {
            boolean bl = false;
            String msg = "error languageTag:" + languageTag;
            Log.e((String)TAG, (String)msg);
            throw new LanguageTagErrorException(msg);
        }
        String translateLangTag = string;
        TranslateRemoteModel translateRemoteModel = new TranslateRemoteModel.Builder(translateLangTag).build();
        Intrinsics.checkNotNullExpressionValue((Object)translateRemoteModel, (String)"Builder(translateLangTag).build()");
        TranslateRemoteModel translateMode = translateRemoteModel;
        DownloadConditions.Builder builder = new DownloadConditions.Builder();
        if (requireWifi) {
            builder.requireWifi();
        }
        if (requireCharging && Build.VERSION.SDK_INT >= 24) {
            builder.requireCharging();
        }
        DownloadConditions downloadConditions = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)downloadConditions, (String)"builder.build()");
        DownloadConditions conditions = downloadConditions;
        RemoteModelManager.getInstance().download((RemoteModel)translateMode, conditions).addOnSuccessListener(arg_0 -> OfflineTranslate.downloadModeImpl$lambda-7(callback, languageTag, arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.downloadModeImpl$lambda-8(callback, languageTag, arg_0));
    }

    private final void ensureMapSizeLimit(ConcurrentHashMap<String, Translator> clientMap, int maxSize) {
        if (clientMap.size() > maxSize) {
            Iterator<Map.Entry<String, Translator>> iterator = clientMap.entrySet().iterator();
            while (clientMap.size() > maxSize && iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"iterator.next()");
                try {
                    Map.Entry<String, Translator> entry;
                    entry.getValue().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                iterator.remove();
            }
        }
    }

    private static final void isDownloadedMode$lambda-1(IDownloadStatusCallback $callback, Boolean isDownloaded) {
        block0: {
            IDownloadStatusCallback iDownloadStatusCallback = $callback;
            if (iDownloadStatusCallback == null) break block0;
            Intrinsics.checkNotNullExpressionValue((Object)isDownloaded, (String)"isDownloaded");
            iDownloadStatusCallback.onSuccess(isDownloaded);
        }
    }

    private static final void isDownloadedMode$lambda-2(IDownloadStatusCallback $callback, Exception e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IDownloadStatusCallback iDownloadStatusCallback = $callback;
            if (iDownloadStatusCallback == null) break block0;
            iDownloadStatusCallback.onFailure(e);
        }
    }

    private static final void translate$lambda-4(OfflineTranslate this$0, String $text, ITranslateCallback $callback, String translatedText) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
            if (this$0.DBG) {
                Log.i((String)TAG, (String)("offline translate success:" + $text + " ->:" + translatedText));
            }
            ITranslateCallback iTranslateCallback = $callback;
            if (iTranslateCallback == null) break block1;
            Intrinsics.checkNotNullExpressionValue((Object)translatedText, (String)"translatedText");
            iTranslateCallback.translateSuccess($text, translatedText);
        }
    }

    private static final void translate$lambda-5(OfflineTranslate this$0, ITranslateCallback $callback, String $text, Exception e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.printStackTrace();
            if (this$0.DBG) {
                Log.e((String)TAG, (String)"offline translate failed.", (Throwable)e);
            }
            ITranslateCallback iTranslateCallback = $callback;
            if (iTranslateCallback == null) break block1;
            iTranslateCallback.translateFailed($text, String.valueOf(e.getMessage()));
        }
    }

    private static final void downloadModeImpl$lambda-7(IDownloadCallback $callback, String $languageTag, Void it) {
        Intrinsics.checkNotNullParameter((Object)$languageTag, (String)"$languageTag");
        IDownloadCallback iDownloadCallback = $callback;
        if (iDownloadCallback != null) {
            iDownloadCallback.downloadSuccess($languageTag);
        }
        Log.i((String)TAG, (String)($languageTag + " download success"));
    }

    private static final void downloadModeImpl$lambda-8(IDownloadCallback $callback, String $languageTag, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$languageTag, (String)"$languageTag");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IDownloadCallback iDownloadCallback = $callback;
        if (iDownloadCallback != null) {
            iDownloadCallback.downloadFailed($languageTag, String.valueOf(it.getMessage()));
        }
        Log.e((String)TAG, (String)($languageTag + " download failed:" + it.getMessage()));
    }

    public OfflineTranslate() {
        this(false, 0, 3, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/hiservice/translate/offline/OfflineTranslate$Companion;", "", "()V", "TAG", "", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

