/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate;

import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.WorkerThread;
import com.hiservice.translate.HiLanguage$HiLanguageBean$;
import com.hiservice.translate.HiLanguage$HiLanguageListBean$;
import com.hiservice.translate.HiLanguageKt;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \n2\u00020\u0001:\u0004\n\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/hiservice/translate/HiLanguage;", "", "()V", "list", "Lcom/hiservice/translate/HiLanguage$HiLanguageListBean;", "type", "Lcom/hiservice/translate/HiLanguage$Type;", "readInputStream", "inputStream", "Ljava/io/InputStream;", "Companion", "HiLanguageBean", "HiLanguageListBean", "Type", "fun-translate_release"})
public final class HiLanguage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String BASE_URL_RELEASE = "https://api.translasion.com/v1/language_list?type=";
    private static int CONNECT_TIME_OUT_MS = 6000;
    private static int READ_TIME_OUT_MS = 8000;
    @NotNull
    private static final String REQUEST_METHOD = "GET";
    @NotNull
    private static final String CONTENT_TYPE = "application/json";
    public static final int ERROR_CODE_NO_CODE = -1;
    public static final int ERROR_CODE_EXCEPTION = -2;

    @WorkerThread
    @NotNull
    public final HiLanguageListBean list(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        try {
            URL url = new URL(BASE_URL_RELEASE + type.getIndex());
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod(REQUEST_METHOD);
            connection.setRequestProperty("content-type", CONTENT_TYPE);
            connection.setConnectTimeout(CONNECT_TIME_OUT_MS);
            connection.setReadTimeout(READ_TIME_OUT_MS);
            connection.setDefaultUseCaches(true);
            connection.setDoOutput(false);
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            HiLanguageListBean result = this.readInputStream(inputStream);
            inputStream.close();
            connection.disconnect();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HiLanguageListBean(-2, e.getMessage(), null, 4, null);
        }
    }

    public static /* synthetic */ HiLanguageListBean list$default(HiLanguage hiLanguage, Type type, int n, Object object) {
        if ((n & 1) != 0) {
            type = Type.TEXT;
        }
        return hiLanguage.list(type);
    }

    private final HiLanguageListBean readInputStream(InputStream inputStream) {
        JSONArray dataObj;
        byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
        String content = new String(bytes, Charsets.UTF_8);
        Log.v((String)"HiService", (String)("language list:" + content));
        JSONObject obj = new JSONObject(content);
        int code = obj.has("code") ? obj.optInt("code") : -1;
        String message = obj.has("message") ? obj.optString("message") : "";
        JSONArray jSONArray = dataObj = obj.has("data") ? obj.optJSONArray("data") : null;
        if (dataObj == null) {
            return new HiLanguageListBean(code, message, null);
        }
        int length = dataObj.length();
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        for (int i = 0; i < length; ++i) {
            Object object = dataObj.optJSONObject(i);
            if (object == null || (object = HiLanguageKt.access$toHiLanguageBean(object)) == null) continue;
            Object it = object;
            boolean bl = false;
            data.add((JSONObject)it);
        }
        return new HiLanguageListBean(code, message, (List<HiLanguageBean>)data);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/hiservice/translate/HiLanguage$Companion;", "", "()V", "BASE_URL_RELEASE", "", "CONNECT_TIME_OUT_MS", "", "getCONNECT_TIME_OUT_MS", "()I", "setCONNECT_TIME_OUT_MS", "(I)V", "CONTENT_TYPE", "ERROR_CODE_EXCEPTION", "ERROR_CODE_NO_CODE", "READ_TIME_OUT_MS", "getREAD_TIME_OUT_MS", "setREAD_TIME_OUT_MS", "REQUEST_METHOD", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCONNECT_TIME_OUT_MS() {
            return CONNECT_TIME_OUT_MS;
        }

        public final void setCONNECT_TIME_OUT_MS(int n) {
            CONNECT_TIME_OUT_MS = n;
        }

        public final int getREAD_TIME_OUT_MS() {
            return READ_TIME_OUT_MS;
        }

        public final void setREAD_TIME_OUT_MS(int n) {
            READ_TIME_OUT_MS = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/hiservice/translate/HiLanguage$Type;", "", "index", "", "(Ljava/lang/String;II)V", "getIndex", "()I", "TEXT", "SPEECH2TEXT", "TEXT2SPEECH", "OCR", "fun-translate_release"})
    public static final class Type
    extends Enum<Type> {
        private final int index;
        public static final /* enum */ Type TEXT = new Type(1);
        public static final /* enum */ Type SPEECH2TEXT = new Type(2);
        public static final /* enum */ Type TEXT2SPEECH = new Type(3);
        public static final /* enum */ Type OCR = new Type(4);
        private static final /* synthetic */ Type[] $VALUES;

        private Type(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.TEXT, Type.SPEECH2TEXT, Type.TEXT2SPEECH, Type.OCR};
        }
    }

    @kotlinx.serialization.Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0002%&B;\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB+\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0011\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J!\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u00c7\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/hiservice/translate/HiLanguage$HiLanguageListBean;", "Ljava/io/Serializable;", "seen1", "", "code", "message", "", "list", "", "Lcom/hiservice/translate/HiLanguage$HiLanguageBean;", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IILjava/lang/String;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(ILjava/lang/String;Ljava/util/List;)V", "getCode", "()I", "getList", "()Ljava/util/List;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "fun-translate_release"})
    @Keep
    public static final class HiLanguageListBean
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int code;
        @Nullable
        private final String message;
        @Nullable
        private final List<HiLanguageBean> list;

        public HiLanguageListBean(int code, @Nullable String message, @Nullable List<HiLanguageBean> list) {
            this.code = code;
            this.message = message;
            this.list = list;
        }

        public /* synthetic */ HiLanguageListBean(int n, String string, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                list = null;
            }
            this(n, string, list);
        }

        public final int getCode() {
            return this.code;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final List<HiLanguageBean> getList() {
            return this.list;
        }

        public final int component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final List<HiLanguageBean> component3() {
            return this.list;
        }

        @NotNull
        public final HiLanguageListBean copy(int code, @Nullable String message, @Nullable List<HiLanguageBean> list) {
            return new HiLanguageListBean(code, message, list);
        }

        public static /* synthetic */ HiLanguageListBean copy$default(HiLanguageListBean hiLanguageListBean, int n, String string, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = hiLanguageListBean.code;
            }
            if ((n2 & 2) != 0) {
                string = hiLanguageListBean.message;
            }
            if ((n2 & 4) != 0) {
                list = hiLanguageListBean.list;
            }
            return hiLanguageListBean.copy(n, string, list);
        }

        @NotNull
        public String toString() {
            return "HiLanguageListBean(code=" + this.code + ", message=" + this.message + ", list=" + this.list + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.code);
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            result = result * 31 + (this.list == null ? 0 : ((Object)this.list).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HiLanguageListBean)) {
                return false;
            }
            HiLanguageListBean hiLanguageListBean = (HiLanguageListBean)other;
            if (this.code != hiLanguageListBean.code) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)hiLanguageListBean.message)) {
                return false;
            }
            return Intrinsics.areEqual(this.list, hiLanguageListBean.list);
        }

        @JvmStatic
        public static final void write$Self(@NotNull HiLanguageListBean self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            output.encodeIntElement(serialDesc, 0, self.code);
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.message != null) {
                output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.message);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.list != null) {
                output.encodeNullableSerializableElement(serialDesc, 2, (SerializationStrategy)new ArrayListSerializer((KSerializer)HiLanguageBean$$serializer.INSTANCE), self.list);
            }
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ HiLanguageListBean(int seen1, int code, String message, List list, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)1, (SerialDescriptor)HiLanguageListBean$$serializer.INSTANCE.getDescriptor());
            }
            this.code = code;
            this.message = (seen1 & 2) == 0 ? null : message;
            this.list = (seen1 & 4) == 0 ? null : list;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/hiservice/translate/HiLanguage$HiLanguageListBean$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/hiservice/translate/HiLanguage$HiLanguageListBean;", "fun-translate_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<HiLanguageListBean> serializer() {
                return (KSerializer)HiLanguageListBean$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @kotlinx.serialization.Serializable
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0005H\u0016J!\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u00c7\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/hiservice/translate/HiLanguage$HiLanguageBean;", "Ljava/io/Serializable;", "seen1", "", "code", "", "name", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "setCode", "(Ljava/lang/String;)V", "getName", "setName", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "fun-translate_release"})
    @Keep
    public static final class HiLanguageBean
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private String code;
        @Nullable
        private String name;

        public HiLanguageBean(@NotNull String code, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
            this.name = name;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public final void setCode(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.code = string;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @NotNull
        public String toString() {
            return this.name + '(' + this.code + ')';
        }

        @NotNull
        public final String component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final HiLanguageBean copy(@NotNull String code, @Nullable String name) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new HiLanguageBean(code, name);
        }

        public static /* synthetic */ HiLanguageBean copy$default(HiLanguageBean hiLanguageBean, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = hiLanguageBean.code;
            }
            if ((n & 2) != 0) {
                string2 = hiLanguageBean.name;
            }
            return hiLanguageBean.copy(string, string2);
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HiLanguageBean)) {
                return false;
            }
            HiLanguageBean hiLanguageBean = (HiLanguageBean)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)hiLanguageBean.code)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)hiLanguageBean.name);
        }

        @JvmStatic
        public static final void write$Self(@NotNull HiLanguageBean self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            output.encodeStringElement(serialDesc, 0, self.code);
            output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.name);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ HiLanguageBean(int seen1, String code, String name, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)HiLanguageBean$$serializer.INSTANCE.getDescriptor());
            }
            this.code = code;
            this.name = name;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/hiservice/translate/HiLanguage$HiLanguageBean$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/hiservice/translate/HiLanguage$HiLanguageBean;", "fun-translate_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<HiLanguageBean> serializer() {
                return (KSerializer)HiLanguageBean$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

