/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.WorkerThread;
import com.hiservice.tools.SPUtil;
import com.hiservice.translate.OfflineTranslateHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper;", "", "context", "Landroid/content/Context;", "listener", "Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;", "(Landroid/content/Context;Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;)V", "downloadLanguageMode", "", "languageCode", "", "getFileNameFromUrl", "url", "getVersionFromUrl", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "isFileDownloaded", "", "unzipFile", "zipFile", "Ljava/io/File;", "targetDirectory", "Companion", "DownloadListener", "fun-translate_release"})
@Keep
public final class LanguageModelDownloadHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final DownloadListener listener;
    @NotNull
    private static final Map<String, String> languageModeMap;
    public static final long TIME_OUT = 30L;
    @NotNull
    public static final String LANGUAGE_MODE_PATH = "com.google.mlkit.translate.models";
    @NotNull
    public static final String FILE_NAME = "language_model.zip";
    @NotNull
    private static final String URL = "https://api.translasion.com/v1/language_list/text/translate";

    public LanguageModelDownloadHelper(@NotNull Context context, @NotNull DownloadListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.context = context;
        this.listener = listener;
    }

    @WorkerThread
    public final void downloadLanguageMode(@NotNull String languageCode) {
        String url;
        Intrinsics.checkNotNullParameter((Object)languageCode, (String)"languageCode");
        String string = languageModeMap.get(languageCode);
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(url = string)).length() == 0) {
            this.listener.onError(new Exception("Can't find download url"), url);
            return;
        }
        if (this.isFileDownloaded(url)) {
            this.listener.onError(new Exception("Already download url"), url);
            return;
        }
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(url).build();
        this.listener.onStartDownload(url);
        client.newCall(request).enqueue(new Callback(this, url){
            final /* synthetic */ LanguageModelDownloadHelper this$0;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$url = $url;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(e, this.$url);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                InputStream inputStream;
                File noBackupDir;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isSuccessful()) {
                    LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(new IOException("Unexpected code " + response), this.$url);
                    return;
                }
                File customDir = OfflineTranslateHelper.Companion.getInstance().getCustomModuleDir();
                File defaultDir = new File(LanguageModelDownloadHelper.access$getContext$p(this.this$0).getNoBackupFilesDir(), "com.google.mlkit.translate.models");
                File file = customDir;
                if (file == null) {
                    file = defaultDir;
                }
                if (!(noBackupDir = file).exists()) {
                    noBackupDir.mkdirs();
                }
                File file2 = new File(noBackupDir, "language_model.zip");
                InputStream inputStream2 = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream2 = response.body().byteStream();
                    outputStream = new FileOutputStream(file2);
                    byte[] buffer = new byte[2048];
                    int bytesRead = 0;
                    long totalSize = response.body().contentLength();
                    long downloadedSize = 0L;
                    InputStream inputStream3 = inputStream2;
                    LanguageModelDownloadHelper languageModelDownloadHelper = this.this$0;
                    String string = this.$url;
                    InputStream it = inputStream3;
                    boolean bl = false;
                    while (true) {
                        int n;
                        int it2 = n = it.read(buffer);
                        boolean bl2 = false;
                        bytesRead = it2;
                        if (n == -1) break;
                        outputStream.write(buffer, 0, bytesRead);
                        downloadedSize += (long)bytesRead;
                        if (totalSize <= 0L) continue;
                        int progress = (int)(downloadedSize * (long)100 / totalSize);
                        LanguageModelDownloadHelper.access$getListener$p(languageModelDownloadHelper).onProgressUpdate(progress, string);
                    }
                    outputStream.flush();
                    SPUtil.INSTANCE.saveLanguageVersion(LanguageModelDownloadHelper.access$getContext$p(languageModelDownloadHelper), LanguageModelDownloadHelper.access$getFileNameFromUrl(languageModelDownloadHelper, string), LanguageModelDownloadHelper.access$getVersionFromUrl(languageModelDownloadHelper, string));
                    LanguageModelDownloadHelper.access$unzipFile(languageModelDownloadHelper, file2, noBackupDir);
                    LanguageModelDownloadHelper.access$getListener$p(languageModelDownloadHelper).onDownloadComplete(file2, string);
                    file2.delete();
                    inputStream = inputStream2;
                }
                catch (Exception e) {
                    InputStream inputStream4;
                    try {
                        LanguageModelDownloadHelper.access$getListener$p(this.this$0).onError(e, this.$url);
                        inputStream4 = inputStream2;
                    }
                    catch (Throwable throwable) {
                        InputStream inputStream5 = inputStream2;
                        if (inputStream5 != null) {
                            inputStream5.close();
                        }
                        FileOutputStream fileOutputStream = outputStream;
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        throw throwable;
                    }
                    if (inputStream4 != null) {
                        inputStream4.close();
                    }
                    FileOutputStream fileOutputStream = outputStream;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                outputStream.close();
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFileDownloaded(String url) {
        File customDir = OfflineTranslateHelper.Companion.getInstance().getCustomModuleDir();
        File defaultDir = new File(this.context.getNoBackupFilesDir(), LANGUAGE_MODE_PATH);
        File file = customDir;
        if (file == null) {
            file = defaultDir;
        }
        File noBackupDir = file;
        String folderPath = noBackupDir.getAbsolutePath();
        Log.v((String)"Sky-", (String)("folderPath:" + folderPath));
        String string = this.getFileNameFromUrl(url);
        if (string == null) {
            string = "";
        }
        String fileName = string;
        String filePath = folderPath + '/' + fileName;
        File file2 = new File(filePath);
        Log.v((String)"Sky-", (String)("file:" + file2.getAbsolutePath() + ", length:" + file2.length()));
        Integer version = this.getVersionFromUrl(url);
        int saveVersion = SPUtil.INSTANCE.getLanguageVersion(this.context, fileName);
        Integer n = version;
        boolean hasNewVersion = (n != null ? n : 1) > saveVersion;
        Log.d((String)"lbx", (String)("" + hasNewVersion + ' ' + version + ' ' + saveVersion));
        if (hasNewVersion) return false;
        if (!file2.exists()) return false;
        if (file2.length() <= 0L) return false;
        File[] fileArray = file2.listFiles();
        if (fileArray == null) return false;
        int n2 = fileArray.length;
        if (n2 <= 2) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getVersionFromUrl(String url) {
        Object object;
        try {
            void $this$associateTo$iv$iv;
            boolean bl = false;
            URI uri = new URI(url);
            String string = uri.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.query");
            String[] stringArray = new String[]{"&"};
            Iterable $this$associate$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                String[] stringArray2 = new String[]{"="};
                List list = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                String key = (String)list.get(0);
                String value = (String)list.get(1);
                Pair pair = TuplesKt.to((Object)key, (Object)value);
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map queryPairs = destination$iv$iv;
            String string2 = (String)queryPairs.get("version");
            object = Result.constructor-impl((Object)(string2 != null ? Integer.parseInt(string2) : 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (Integer)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private final String getFileNameFromUrl(String url) {
        Object object;
        try {
            boolean bl = false;
            object = Result.constructor-impl((Object)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null), (String)".", null, (int)2, null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void unzipFile(File zipFile, File targetDirectory) throws IOException {
        var3_3 = new ZipInputStream(new FileInputStream(zipFile));
        var4_4 = null;
        try {
            zis = (ZipInputStream)var3_3;
            $i$a$-use-LanguageModelDownloadHelper$unzipFile$1 = false;
            zipEntry = null;
            buffer = new byte[1024];
            while (true) lbl-1000:
            // 4 sources

            {
                it = var9_11 = zis.getNextEntry();
                $i$a$-also-LanguageModelDownloadHelper$unzipFile$1$1 = false;
                zipEntry = it;
                if (var9_11 == null) ** break;
                v0 = zipEntry;
                Intrinsics.checkNotNull((Object)v0);
                newFile = new File(targetDirectory, v0.getName());
                if (zipEntry.isDirectory()) {
                    if (newFile.isDirectory() || newFile.mkdirs()) continue;
                    throw new IOException("Failed to create directory " + newFile.getAbsolutePath());
                }
                parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent.getAbsolutePath());
                }
                var11_14 = new FileOutputStream(newFile);
                var12_15 = null;
                try {
                    fos = (FileOutputStream)var11_14;
                    $i$a$-use-LanguageModelDownloadHelper$unzipFile$1$2 = false;
                    len = 0;
                    while (true) {
                        it = var16_21 = zis.read(buffer);
                        $i$a$-also-LanguageModelDownloadHelper$unzipFile$1$2$1 = false;
                        len = it;
                        if (var16_21 <= 0) break;
                        fos.write(buffer, 0, len);
                    }
                    var13_16 = Unit.INSTANCE;
                }
                catch (Throwable var13_17) {
                    var12_15 = var13_17;
                    throw var13_17;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var11_14, (Throwable)var12_15);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            var5_5 = Unit.INSTANCE;
        }
        catch (Throwable var5_6) {
            var4_4 = var5_6;
            throw var5_6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var3_3, (Throwable)var4_4);
        }
    }

    @JvmStatic
    public static final void fetchLanguageModeMap$fun_translate_release() {
        Companion.fetchLanguageModeMap$fun_translate_release();
    }

    public static final /* synthetic */ Map access$getLanguageModeMap$cp() {
        return languageModeMap;
    }

    public static final /* synthetic */ DownloadListener access$getListener$p(LanguageModelDownloadHelper $this) {
        return $this.listener;
    }

    public static final /* synthetic */ Context access$getContext$p(LanguageModelDownloadHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$getFileNameFromUrl(LanguageModelDownloadHelper $this, String url) {
        return $this.getFileNameFromUrl(url);
    }

    public static final /* synthetic */ Integer access$getVersionFromUrl(LanguageModelDownloadHelper $this, String url) {
        return $this.getVersionFromUrl(url);
    }

    public static final /* synthetic */ void access$unzipFile(LanguageModelDownloadHelper $this, File zipFile, File targetDirectory) {
        $this.unzipFile(zipFile, targetDirectory);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"af", (Object)"https://support.igofun.mobi/offline_translate/af_en.zip"), TuplesKt.to((Object)"ar", (Object)"https://support.igofun.mobi/offline_translate/ar_en.zip"), TuplesKt.to((Object)"be", (Object)"https://support.igofun.mobi/offline_translate/be_en.zip"), TuplesKt.to((Object)"bg", (Object)"https://support.igofun.mobi/offline_translate/bg_en.zip"), TuplesKt.to((Object)"bn", (Object)"https://support.igofun.mobi/offline_translate/bn_en.zip"), TuplesKt.to((Object)"ca", (Object)"https://support.igofun.mobi/offline_translate/ca_en.zip"), TuplesKt.to((Object)"cs", (Object)"https://support.igofun.mobi/offline_translate/cs_en.zip"), TuplesKt.to((Object)"cy", (Object)"https://support.igofun.mobi/offline_translate/cy_en.zip"), TuplesKt.to((Object)"da", (Object)"https://support.igofun.mobi/offline_translate/da_en.zip"), TuplesKt.to((Object)"de", (Object)"https://support.igofun.mobi/offline_translate/de_en.zip"), TuplesKt.to((Object)"el", (Object)"https://support.igofun.mobi/offline_translate/el_en.zip"), TuplesKt.to((Object)"eo", (Object)"https://support.igofun.mobi/offline_translate/en_eo.zip"), TuplesKt.to((Object)"es", (Object)"https://support.igofun.mobi/offline_translate/en_es.zip"), TuplesKt.to((Object)"et", (Object)"https://support.igofun.mobi/offline_translate/en_et.zip"), TuplesKt.to((Object)"fa", (Object)"https://support.igofun.mobi/offline_translate/en_fa.zip"), TuplesKt.to((Object)"fi", (Object)"https://support.igofun.mobi/offline_translate/en_fi.zip"), TuplesKt.to((Object)"fr", (Object)"https://support.igofun.mobi/offline_translate/en_fr.zip"), TuplesKt.to((Object)"ga", (Object)"https://support.igofun.mobi/offline_translate/en_ga.zip"), TuplesKt.to((Object)"gl", (Object)"https://support.igofun.mobi/offline_translate/en_gl.zip"), TuplesKt.to((Object)"gu", (Object)"https://support.igofun.mobi/offline_translate/en_gu.zip"), TuplesKt.to((Object)"he", (Object)"https://support.igofun.mobi/offline_translate/en_iw.zip"), TuplesKt.to((Object)"hi", (Object)"https://support.igofun.mobi/offline_translate/en_hi.zip"), TuplesKt.to((Object)"hr", (Object)"https://support.igofun.mobi/offline_translate/en_hr.zip"), TuplesKt.to((Object)"ht", (Object)"https://support.igofun.mobi/offline_translate/en_ht.zip"), TuplesKt.to((Object)"hu", (Object)"https://support.igofun.mobi/offline_translate/en_hu.zip"), TuplesKt.to((Object)"id", (Object)"https://support.igofun.mobi/offline_translate/en_id.zip"), TuplesKt.to((Object)"is", (Object)"https://support.igofun.mobi/offline_translate/en_is.zip"), TuplesKt.to((Object)"it", (Object)"https://support.igofun.mobi/offline_translate/en_it.zip"), TuplesKt.to((Object)"ja", (Object)"https://support.igofun.mobi/offline_translate/en_ja.zip"), TuplesKt.to((Object)"ka", (Object)"https://support.igofun.mobi/offline_translate/en_ka.zip"), TuplesKt.to((Object)"kn", (Object)"https://support.igofun.mobi/offline_translate/en_kn.zip"), TuplesKt.to((Object)"ko", (Object)"https://support.igofun.mobi/offline_translate/en_ko.zip"), TuplesKt.to((Object)"lt", (Object)"https://support.igofun.mobi/offline_translate/en_lt.zip"), TuplesKt.to((Object)"lv", (Object)"https://support.igofun.mobi/offline_translate/en_lv.zip"), TuplesKt.to((Object)"mk", (Object)"https://support.igofun.mobi/offline_translate/en_mk.zip"), TuplesKt.to((Object)"mr", (Object)"https://support.igofun.mobi/offline_translate/en_mr.zip"), TuplesKt.to((Object)"ms", (Object)"https://support.igofun.mobi/offline_translate/en_ms.zip"), TuplesKt.to((Object)"mt", (Object)"https://support.igofun.mobi/offline_translate/en_mt.zip"), TuplesKt.to((Object)"nl", (Object)"https://support.igofun.mobi/offline_translate/en_nl.zip"), TuplesKt.to((Object)"no", (Object)"https://support.igofun.mobi/offline_translate/en_no.zip"), TuplesKt.to((Object)"pl", (Object)"https://support.igofun.mobi/offline_translate/en_pl.zip"), TuplesKt.to((Object)"pt", (Object)"https://support.igofun.mobi/offline_translate/en_pt.zip"), TuplesKt.to((Object)"ro", (Object)"https://support.igofun.mobi/offline_translate/en_ro.zip"), TuplesKt.to((Object)"ru", (Object)"https://support.igofun.mobi/offline_translate/en_ru.zip"), TuplesKt.to((Object)"sk", (Object)"https://support.igofun.mobi/offline_translate/en_sk.zip"), TuplesKt.to((Object)"sl", (Object)"https://support.igofun.mobi/offline_translate/en_sl.zip"), TuplesKt.to((Object)"sq", (Object)"https://support.igofun.mobi/offline_translate/en_sq.zip"), TuplesKt.to((Object)"sv", (Object)"https://support.igofun.mobi/offline_translate/en_sv.zip"), TuplesKt.to((Object)"sw", (Object)"https://support.igofun.mobi/offline_translate/en_sw.zip"), TuplesKt.to((Object)"ta", (Object)"https://support.igofun.mobi/offline_translate/en_ta.zip"), TuplesKt.to((Object)"te", (Object)"https://support.igofun.mobi/offline_translate/en_te.zip"), TuplesKt.to((Object)"th", (Object)"https://support.igofun.mobi/offline_translate/en_th.zip"), TuplesKt.to((Object)"tl", (Object)"https://support.igofun.mobi/offline_translate/en_tl.zip"), TuplesKt.to((Object)"tr", (Object)"https://support.igofun.mobi/offline_translate/en_tr.zip"), TuplesKt.to((Object)"uk", (Object)"https://support.igofun.mobi/offline_translate/en_uk.zip"), TuplesKt.to((Object)"ur", (Object)"https://support.igofun.mobi/offline_translate/en_ur.zip"), TuplesKt.to((Object)"vi", (Object)"https://support.igofun.mobi/offline_translate/en_vi.zip"), TuplesKt.to((Object)"zh", (Object)"https://support.igofun.mobi/offline_translate/en_zh.zip")};
        languageModeMap = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u000b\u001a\u00020\fH\u0001\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper$Companion;", "", "()V", "FILE_NAME", "", "LANGUAGE_MODE_PATH", "TIME_OUT", "", "URL", "languageModeMap", "", "fetchLanguageModeMap", "", "fetchLanguageModeMap$fun_translate_release", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void fetchLanguageModeMap$fun_translate_release() {
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            Request request = new Request.Builder().url("https://api.translasion.com/v1/language_list/text/translate?to=en&package_name=com.hiservice&version_code=1&version_name=2.1.4-alpha1").build();
            client.newCall(request).enqueue(new Callback(){

                public void onResponse(@Nullable Call call, @Nullable Response response) {
                    try {
                        String string;
                        String string2;
                        boolean bl = false;
                        Response response2 = response;
                        String string3 = string2 = response2 != null && (response2 = response2.body()) != null ? response2.string() : null;
                        if (string3 == null) {
                            string = "";
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"response?.body()?.string() ?: \"\"");
                            string = string2;
                        }
                        JSONObject obj = new JSONObject(string);
                        int code = obj.optInt("code");
                        if (code == 1000) {
                            JSONArray jSONArray;
                            JSONArray jSONArray2 = jSONArray = obj.optJSONArray("data");
                            if (jSONArray2 == null) {
                                return;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)jSONArray2, (String)"obj.optJSONArray(\"data\") ?: return");
                            JSONArray array = jSONArray;
                            int n = array.length();
                            for (int i = 0; i < n; ++i) {
                                JSONObject jSONObject;
                                JSONObject jSONObject2;
                                JSONObject jSONObject3 = jSONObject2 = array.optJSONObject(i);
                                if (jSONObject3 == null) continue;
                                Intrinsics.checkNotNullExpressionValue((Object)jSONObject3, (String)"array.optJSONObject(i) ?: continue");
                                JSONObject item = jSONObject2;
                                JSONObject jSONObject4 = jSONObject = item.optJSONObject("translate");
                                if (jSONObject4 == null) continue;
                                Intrinsics.checkNotNullExpressionValue((Object)jSONObject4, (String)"item.optJSONObject(\"translate\") ?: continue");
                                JSONObject translate = jSONObject;
                                String key = translate.optString("code");
                                String checksum = translate.optString("checksum");
                                String url = translate.optString("url");
                                String v = translate.optString("version");
                                String value = url + "?checksum=" + checksum + "&version=" + v;
                                Log.d((String)"lbx", (String)value);
                                Map map = LanguageModelDownloadHelper.access$getLanguageModeMap$cp();
                                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                                map.put(key, value);
                            }
                        }
                        Object object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                }

                public void onFailure(@Nullable Call call, @Nullable IOException e) {
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001c\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\u0010"}, d2={"Lcom/hiservice/translate/LanguageModelDownloadHelper$DownloadListener;", "", "onDownloadComplete", "", "file", "Ljava/io/File;", "url", "", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onProgressUpdate", "percentage", "", "onStartDownload", "fun-translate_release"})
    public static interface DownloadListener {
        public void onStartDownload(@NotNull String var1);

        public void onProgressUpdate(int var1, @NotNull String var2);

        public void onDownloadComplete(@NotNull File var1, @NotNull String var2);

        public void onError(@NotNull Exception var1, @NotNull String var2);
    }
}

