/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate.offline;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.WorkerThread;
import com.google.mlkit.common.model.DownloadConditions;
import com.google.mlkit.common.model.RemoteModel;
import com.google.mlkit.common.model.RemoteModelManager;
import com.google.mlkit.common.sdkinternal.model.ModelFileHelper;
import com.google.mlkit.nl.translate.TranslateLanguage;
import com.google.mlkit.nl.translate.TranslateRemoteModel;
import com.google.mlkit.nl.translate.Translation;
import com.google.mlkit.nl.translate.Translator;
import com.google.mlkit.nl.translate.TranslatorOptions;
import com.hiservice.translate.OfflineTranslateHelper;
import com.hiservice.translate.offline.IDownloadCallback;
import com.hiservice.translate.offline.IDownloadStatusCallback;
import com.hiservice.translate.offline.IOfflineTranslate;
import com.hiservice.translate.offline.ITranslateCallback;
import com.hiservice.translate.offline.LanguageTagErrorException;
import com.hiservice.translate.offline.OfflineApplication;
import com.hiservice.translate.offline.ParamDownload;
import com.hiservice.translate.offline.ParamModel;
import com.hiservice.translate.offline.ParamTranslateText;
import com.hiservice.translate.offline.cases.FixModuleCase;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 52\u00020\u0001:\u00015B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0017J*\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J$\u0010 \u001a\u00020\u00162\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010!\u001a\u00020\u0005H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\fH\u0016J\"\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0016J\u001a\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\b\u0010\u001a\u001a\u0004\u0018\u00010+H\u0016J\u001a\u0010,\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\b\u0010-\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010.\u001a\u00020\u00162\b\u0010/\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u0002022\b\u0010\u001a\u001a\u0004\u0018\u000103H\u0016J,\u00100\u001a\u00020\u00162\u0006\u00104\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u000103H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00066"}, d2={"Lcom/hiservice/translate/offline/OfflineTranslate;", "Lcom/hiservice/translate/offline/IOfflineTranslate;", "DBG", "", "count", "", "(ZI)V", "clientMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/google/mlkit/nl/translate/Translator;", "customModuleDir", "Ljava/io/File;", "mFixModuleCase", "Lcom/hiservice/translate/offline/cases/FixModuleCase;", "getMFixModuleCase", "()Lcom/hiservice/translate/offline/cases/FixModuleCase;", "mFixModuleCase$delegate", "Lkotlin/Lazy;", "allLanguageTags", "", "destroy", "", "downloadMode", "paramDownload", "Lcom/hiservice/translate/offline/ParamDownload;", "callback", "Lcom/hiservice/translate/offline/IDownloadCallback;", "downloadModeImpl", "languageTag", "requireWifi", "requireCharging", "ensureMapSizeLimit", "maxSize", "getCustomModuleDir", "getModuleDir", "context", "Landroid/content/Context;", "fromCode", "toCode", "isDownloadedMode", "paramModel", "Lcom/hiservice/translate/offline/ParamModel;", "Lcom/hiservice/translate/offline/IDownloadStatusCallback;", "setCustomModuleDir", "file", "setCustomModuleSubDir", "customDir", "translate", "paramTranslateText", "Lcom/hiservice/translate/offline/ParamTranslateText;", "Lcom/hiservice/translate/offline/ITranslateCallback;", "text", "Companion", "fun-translate_release"})
public final class OfflineTranslate
implements IOfflineTranslate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean DBG;
    private final int count;
    @NotNull
    private final ConcurrentHashMap<String, Translator> clientMap;
    @Nullable
    private File customModuleDir;
    @NotNull
    private final Lazy mFixModuleCase$delegate;
    @NotNull
    private static final String TAG = "OfflineTranslate";

    public OfflineTranslate(boolean DBG, int count) {
        this.DBG = DBG;
        this.count = count;
        this.clientMap = new ConcurrentHashMap();
        this.mFixModuleCase$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FixModuleCase>(this){
            final /* synthetic */ OfflineTranslate this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FixModuleCase invoke() {
                return new FixModuleCase(OfflineTranslate.access$getDBG$p(this.this$0));
            }
        }));
    }

    public /* synthetic */ OfflineTranslate(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(bl, n);
    }

    private final FixModuleCase getMFixModuleCase() {
        Lazy lazy = this.mFixModuleCase$delegate;
        return (FixModuleCase)lazy.getValue();
    }

    @Override
    @WorkerThread
    public void downloadMode(@NotNull ParamDownload paramDownload, @Nullable IDownloadCallback callback) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)paramDownload, (String)"paramDownload");
            try {
                String languageTag = paramDownload.getLanguageTag();
                boolean requireWifi = paramDownload.getRequireWifi();
                boolean requireCharging = paramDownload.getRequireCharging();
                this.downloadModeImpl(languageTag, requireWifi, requireCharging, callback);
            }
            catch (Exception e) {
                e.printStackTrace();
                IDownloadCallback iDownloadCallback = callback;
                if (iDownloadCallback == null) break block3;
                String string = paramDownload.getLanguageTag();
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "-1";
                }
                iDownloadCallback.downloadFailed(string, string2);
            }
        }
    }

    @Override
    public void translate(@NotNull ParamTranslateText paramTranslateText, @Nullable ITranslateCallback callback) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)paramTranslateText, (String)"paramTranslateText");
            try {
                this.translate(paramTranslateText.getText(), paramTranslateText.getFromLanguageCode(), paramTranslateText.getToLanguageCode(), callback);
            }
            catch (Exception e) {
                e.printStackTrace();
                ITranslateCallback iTranslateCallback = callback;
                if (iTranslateCallback == null) break block3;
                String string = paramTranslateText.getText();
                String string2 = e.getMessage();
                if (string2 == null) {
                    string2 = "-2";
                }
                iTranslateCallback.translateFailed(string, string2);
            }
        }
    }

    @Override
    @NotNull
    public List<String> allLanguageTags() {
        List list = TranslateLanguage.getAllLanguages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllLanguages()");
        return list;
    }

    @Override
    public void isDownloadedMode(@NotNull ParamModel paramModel, @Nullable IDownloadStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)paramModel, (String)"paramModel");
        String string = TranslateLanguage.fromLanguageTag((String)paramModel.getLanguageTag());
        if (string == null) {
            boolean bl = false;
            String msg = "error languageTag:" + paramModel + ".languageTag";
            Log.e((String)TAG, (String)msg);
            throw new LanguageTagErrorException(msg);
        }
        String languageTag = string;
        TranslateRemoteModel translateRemoteModel = new TranslateRemoteModel.Builder(languageTag).build();
        Intrinsics.checkNotNullExpressionValue((Object)translateRemoteModel, (String)"Builder(languageTag).build()");
        TranslateRemoteModel translateMode = translateRemoteModel;
        RemoteModelManager remoteModelManager = RemoteModelManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)remoteModelManager, (String)"getInstance()");
        RemoteModelManager modelManager = remoteModelManager;
        modelManager.isModelDownloaded((RemoteModel)translateMode).addOnSuccessListener(arg_0 -> OfflineTranslate.isDownloadedMode$lambda-1(callback, arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.isDownloadedMode$lambda-2(callback, arg_0));
    }

    @Override
    public void destroy() {
        try {
            Map $this$forEach$iv = this.clientMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Translator translator = (Translator)entry.getValue();
                try {
                    translator.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.clientMap.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean setCustomModuleDir(@NotNull Context context, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context app = context.getApplicationContext();
        if (!(app instanceof OfflineApplication)) {
            Log.e((String)TAG, (String)"setCustomModuleDir, application is not OfflineApplication");
            return false;
        }
        File file2 = file;
        if (file2 == null) {
            return false;
        }
        File f = file2;
        if (!f.exists() && !f.mkdirs()) {
            Log.e((String)TAG, (String)("setCustomModuleDir, file is not exists:" + f.getAbsolutePath()));
            return false;
        }
        if (!f.isDirectory()) {
            Log.e((String)TAG, (String)("setCustomModuleDir, file is not directory:" + f.getAbsolutePath()));
            return false;
        }
        String moduleDirName = f.getName();
        CharSequence charSequence = moduleDirName;
        if (charSequence == null || charSequence.length() == 0) {
            Log.e((String)TAG, (String)("setCustomModuleDir, moduleDirName is Empty :" + moduleDirName));
            return false;
        }
        this.customModuleDir = f;
        this.setCustomModuleSubDir(moduleDirName);
        Log.i((String)TAG, (String)("setCustomModuleDir success, custom module dir:" + f.getAbsolutePath()));
        return true;
    }

    @Override
    @Nullable
    public File getCustomModuleDir() {
        File file = this.customModuleDir;
        if (file == null) {
            return null;
        }
        File file2 = file;
        Log.i((String)TAG, (String)("getCustomModuleDir success, custom dir:" + file2.getAbsolutePath() + '.'));
        return file2;
    }

    @Override
    @Nullable
    public File getModuleDir(@NotNull Context context, @NotNull String fromCode, @NotNull String toCode) {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fromCode, (String)"fromCode");
        Intrinsics.checkNotNullParameter((Object)toCode, (String)"toCode");
        File customDir = OfflineTranslateHelper.Companion.getInstance().getCustomModuleDir();
        File defaultDir = new File(context.getNoBackupFilesDir(), "com.google.mlkit.translate.models");
        File file2 = customDir;
        if (file2 == null) {
            file2 = defaultDir;
        }
        File noBackupDir = file2;
        String folderPath = noBackupDir.getAbsolutePath();
        if (this.DBG) {
            Log.v((String)TAG, (String)("fromCode:" + fromCode + ", toCode:" + toCode));
            Log.v((String)TAG, (String)("folderPath:" + folderPath));
        }
        if ((file = new File(noBackupDir, fromCode + '_' + toCode)).exists()) {
            if (this.DBG) {
                Log.v((String)TAG, (String)("folderPath:" + file.getAbsolutePath()));
            }
            return file;
        }
        File file3 = new File(noBackupDir, toCode + '_' + fromCode);
        if (file3.exists()) {
            if (this.DBG) {
                Log.v((String)TAG, (String)("folderPath3:" + file3.getAbsolutePath()));
            }
            return file3;
        }
        if (this.DBG) {
            Log.v((String)TAG, (String)"folderPath5:null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCustomModuleSubDir(String customDir) {
        try {
            String string = customDir;
            if (string != null) {
                String it = string;
                boolean bl = false;
                String string2 = ModelFileHelper.zza;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"zza");
                String before = string2;
                Log.i((String)TAG, (String)("Updated zza value: " + before));
                Class<?> clazz = Class.forName("com.google.mlkit.common.sdkinternal.model.ModelFileHelper");
                Field field = clazz.getDeclaredField("zza");
                field.setAccessible(true);
                field.set(null, it);
                Log.e((String)TAG, (String)("Updated zza value: " + field.get(null) + ", zza:" + ModelFileHelper.zza));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void translate(String text, String fromCode, String toCode, ITranslateCallback callback) {
        String string;
        String fixTranslatedEnText = this.getMFixModuleCase().translate(text, fromCode, "en");
        if (fixTranslatedEnText != null) {
            fixTranslatedEnText = this.getMFixModuleCase().translate(fixTranslatedEnText, "en", toCode);
        }
        if ((string = fixTranslatedEnText) != null) {
            String it = string;
            boolean bl = false;
            ITranslateCallback iTranslateCallback = callback;
            if (iTranslateCallback != null) {
                iTranslateCallback.translateSuccess(text, it);
            }
            return;
        }
        String key = fromCode + toCode;
        Translator translator = this.clientMap.get(key);
        if (translator == null) {
            TranslatorOptions translatorOptions = new TranslatorOptions.Builder().setSourceLanguage(fromCode).setTargetLanguage(toCode).build();
            Intrinsics.checkNotNullExpressionValue((Object)translatorOptions, (String)"Builder()\n              \u2026\n                .build()");
            TranslatorOptions options = translatorOptions;
            translator = Translation.getClient((TranslatorOptions)options);
            this.ensureMapSizeLimit(this.clientMap, Math.max(this.count - 1, 0));
            ((Map)this.clientMap).put(key, translator);
        }
        if (this.DBG) {
            Log.i((String)TAG, (String)("offline translate " + fromCode + " - " + toCode + ", txt:" + text));
        }
        translator.translate(text).addOnSuccessListener(arg_0 -> OfflineTranslate.translate$lambda-6(this, text, callback, arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.translate$lambda-7(this, callback, text, arg_0));
    }

    static /* synthetic */ void translate$default(OfflineTranslate offlineTranslate, String string, String string2, String string3, ITranslateCallback iTranslateCallback, int n, Object object) {
        if ((n & 8) != 0) {
            iTranslateCallback = null;
        }
        offlineTranslate.translate(string, string2, string3, iTranslateCallback);
    }

    private final void downloadModeImpl(String languageTag, boolean requireWifi, boolean requireCharging, IDownloadCallback callback) {
        Log.v((String)TAG, (String)("start download offline translate mode: " + languageTag + ", requireWifi:" + requireWifi + ", requireCharging:" + requireCharging));
        String string = TranslateLanguage.fromLanguageTag((String)languageTag);
        if (string == null) {
            boolean bl = false;
            String msg = "error languageTag:" + languageTag;
            Log.e((String)TAG, (String)msg);
            throw new LanguageTagErrorException(msg);
        }
        String translateLangTag = string;
        TranslateRemoteModel translateRemoteModel = new TranslateRemoteModel.Builder(translateLangTag).build();
        Intrinsics.checkNotNullExpressionValue((Object)translateRemoteModel, (String)"Builder(translateLangTag).build()");
        TranslateRemoteModel translateMode = translateRemoteModel;
        DownloadConditions.Builder builder = new DownloadConditions.Builder();
        if (requireWifi) {
            builder.requireWifi();
        }
        if (requireCharging && Build.VERSION.SDK_INT >= 24) {
            builder.requireCharging();
        }
        DownloadConditions downloadConditions = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)downloadConditions, (String)"builder.build()");
        DownloadConditions conditions = downloadConditions;
        RemoteModelManager.getInstance().download((RemoteModel)translateMode, conditions).addOnSuccessListener(arg_0 -> OfflineTranslate.downloadModeImpl$lambda-9(callback, languageTag, arg_0)).addOnFailureListener(arg_0 -> OfflineTranslate.downloadModeImpl$lambda-10(callback, languageTag, arg_0));
    }

    private final void ensureMapSizeLimit(ConcurrentHashMap<String, Translator> clientMap, int maxSize) {
        if (clientMap.size() > maxSize) {
            Iterator<Map.Entry<String, Translator>> iterator = clientMap.entrySet().iterator();
            while (clientMap.size() > maxSize && iterator.hasNext()) {
                Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"iterator.next()");
                try {
                    Map.Entry<String, Translator> entry;
                    entry.getValue().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                iterator.remove();
            }
        }
    }

    private static final void isDownloadedMode$lambda-1(IDownloadStatusCallback $callback, Boolean isDownloaded) {
        block0: {
            IDownloadStatusCallback iDownloadStatusCallback = $callback;
            if (iDownloadStatusCallback == null) break block0;
            Intrinsics.checkNotNullExpressionValue((Object)isDownloaded, (String)"isDownloaded");
            iDownloadStatusCallback.onSuccess(isDownloaded);
        }
    }

    private static final void isDownloadedMode$lambda-2(IDownloadStatusCallback $callback, Exception e) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IDownloadStatusCallback iDownloadStatusCallback = $callback;
            if (iDownloadStatusCallback == null) break block0;
            iDownloadStatusCallback.onFailure(e);
        }
    }

    private static final void translate$lambda-6(OfflineTranslate this$0, String $text, ITranslateCallback $callback, String translatedText) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
            if (this$0.DBG) {
                Log.i((String)TAG, (String)("offline translate success:" + $text + " ->:" + translatedText));
            }
            ITranslateCallback iTranslateCallback = $callback;
            if (iTranslateCallback == null) break block1;
            Intrinsics.checkNotNullExpressionValue((Object)translatedText, (String)"translatedText");
            iTranslateCallback.translateSuccess($text, translatedText);
        }
    }

    private static final void translate$lambda-7(OfflineTranslate this$0, ITranslateCallback $callback, String $text, Exception e) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.printStackTrace();
            if (this$0.DBG) {
                Log.e((String)TAG, (String)"offline translate failed.", (Throwable)e);
            }
            ITranslateCallback iTranslateCallback = $callback;
            if (iTranslateCallback == null) break block1;
            iTranslateCallback.translateFailed($text, String.valueOf(e.getMessage()));
        }
    }

    private static final void downloadModeImpl$lambda-9(IDownloadCallback $callback, String $languageTag, Void it) {
        Intrinsics.checkNotNullParameter((Object)$languageTag, (String)"$languageTag");
        IDownloadCallback iDownloadCallback = $callback;
        if (iDownloadCallback != null) {
            iDownloadCallback.downloadSuccess($languageTag);
        }
        Log.i((String)TAG, (String)($languageTag + " download success"));
    }

    private static final void downloadModeImpl$lambda-10(IDownloadCallback $callback, String $languageTag, Exception it) {
        Intrinsics.checkNotNullParameter((Object)$languageTag, (String)"$languageTag");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IDownloadCallback iDownloadCallback = $callback;
        if (iDownloadCallback != null) {
            iDownloadCallback.downloadFailed($languageTag, String.valueOf(it.getMessage()));
        }
        Log.e((String)TAG, (String)($languageTag + " download failed:" + it.getMessage()));
    }

    public OfflineTranslate() {
        this(false, 0, 3, null);
    }

    public static final /* synthetic */ boolean access$getDBG$p(OfflineTranslate $this) {
        return $this.DBG;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/hiservice/translate/offline/OfflineTranslate$Companion;", "", "()V", "TAG", "", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

