/*
 * Decompiled with CFR 0.152.
 */
package com.hiservice.translate.offline.cases;

import android.util.Log;
import com.hiservice.translate.OfflineTranslateHelper;
import com.hiservice.translate.offline.cases.TranslationItem;
import com.hiservice.translate.offline.cases.Translations;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hiservice/translate/offline/cases/FixModuleCase;", "", "dbg", "", "(Z)V", "parseJsonManually", "Lcom/hiservice/translate/offline/cases/Translations;", "jsonString", "", "translate", "text", "fromCode", "toCode", "Companion", "fun-translate_release"})
public final class FixModuleCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean dbg;
    @NotNull
    private static final String KEY_DATA_JSON = ".json";
    @NotNull
    private static final String TAG = "FixModuleCase";

    public FixModuleCase(boolean dbg) {
        this.dbg = dbg;
    }

    public /* synthetic */ FixModuleCase(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String translate(@NotNull String text, @NotNull String fromCode, @NotNull String toCode) {
        Object v2;
        block22: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)fromCode, (String)"fromCode");
            Intrinsics.checkNotNullParameter((Object)toCode, (String)"toCode");
            if (Intrinsics.areEqual((Object)fromCode, (Object)toCode)) {
                return text;
            }
            File file = OfflineTranslateHelper.Companion.getInstance().getModuleDir(fromCode, toCode);
            if (file == null) {
                return null;
            }
            File moduleDir = file;
            File dataJsonFile = new File(moduleDir, fromCode + '_' + toCode + KEY_DATA_JSON);
            if (this.dbg) {
                Log.v((String)TAG, (String)("translate, dataJsonFile:" + dataJsonFile.getAbsolutePath()));
            }
            if (!dataJsonFile.exists()) {
                if (this.dbg) {
                    Log.e((String)TAG, (String)("translate, dataJsonFile:" + dataJsonFile.getAbsolutePath() + ", not exists."));
                }
                return null;
            }
            Closeable closeable = new FileInputStream(dataJsonFile);
            Throwable throwable = null;
            try {
                Object inputStream = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new InputStreamReader((InputStream)inputStream);
                Throwable throwable2 = null;
                try {
                    Object reader = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    reader = TextStreamsKt.readText((Reader)((Reader)reader));
                }
                catch (Throwable reader) {
                    throwable2 = reader;
                    throw reader;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                inputStream = reader;
            }
            catch (Throwable inputStream) {
                throwable = inputStream;
                throw inputStream;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object jsonString = inputStream;
            Translations translations = this.parseJsonManually((String)jsonString);
            if (translations == null) {
                return null;
            }
            Translations translations2 = translations;
            Iterable $this$firstOrNull$iv = translations2.getTms();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TranslationItem it = (TranslationItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSrc(), (Object)text)) continue;
                v2 = element$iv;
                break block22;
            }
            v2 = null;
        }
        TranslationItem first = v2;
        if (first == null) {
            if (this.dbg) {
                Log.e((String)TAG, (String)"translate, translations.tms not ket.");
            }
            return null;
        }
        if (this.dbg) {
            Log.i((String)TAG, (String)("translate, return:" + first.getTgt()));
        }
        return first.getTgt();
    }

    private final Translations parseJsonManually(String jsonString) {
        Translations translations;
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            JSONArray jSONArray = jsonObject.getJSONArray("tms");
            Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"jsonObject.getJSONArray(\"tms\")");
            JSONArray tmsArray = jSONArray;
            List translationItems = new ArrayList();
            int n = tmsArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject itemObject = tmsArray.getJSONObject(i);
                String src = itemObject.getString("src");
                String tgt = itemObject.getString("tgt");
                Intrinsics.checkNotNullExpressionValue((Object)src, (String)"src");
                Intrinsics.checkNotNullExpressionValue((Object)tgt, (String)"tgt");
                translationItems.add(new TranslationItem(src, tgt));
            }
            translations = new Translations(translationItems);
        }
        catch (Exception e) {
            e.printStackTrace();
            translations = null;
        }
        return translations;
    }

    public FixModuleCase() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/hiservice/translate/offline/cases/FixModuleCase$Companion;", "", "()V", "KEY_DATA_JSON", "", "TAG", "fun-translate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

