package com.hyprmx.android.sdk.activity

import android.os.Bundle
import com.hyprmx.android.sdk.api.data.WebTrafficAd
import com.hyprmx.android.sdk.core.ViewControllerModule
import com.hyprmx.android.sdk.presentation.ActivityResultListener

internal interface AdControllerFactory {
  var controller: HyprMXBaseViewController?
  val activityResultListener: ActivityResultListener

  fun createAdViewController(
    activity: HyprMXOfferViewerActivity,
    savedInstanceState: Bundle?,
    viewControllerListener: HyprMXBaseViewController.HyprMXBaseViewControllerListener,
  ): HyprMXBaseViewController
}

internal class DefaultAdViewControllerFactory(private val viewControllerModule: ViewControllerModule) :
  AdControllerFactory, ViewControllerModule by viewControllerModule {

  override var controller: HyprMXBaseViewController? = null

  override fun createAdViewController(
    activity: HyprMXOfferViewerActivity,
    savedInstanceState: Bundle?,
    viewControllerListener: HyprMXBaseViewController.HyprMXBaseViewControllerListener,
  ): HyprMXBaseViewController {
    return when (ad.type) {
      HyprMXOfferViewerActivity.WEBTRAFFIC_OFFER -> {
        HyprMXWebTrafficViewController(
          activity = activity,
          distributorId = distributorId,
          savedInstanceState = savedInstanceState,
          ad = ad as WebTrafficAd,
          viewControllerListener = viewControllerListener,
          eventController = eventController,
          imageCacheManager = imageCacheManager,
          webViewFactory = webViewFactory,
          activityResultListener = activityResultListener,
          openMeasurementController = openMeasurementController,
          powerSaveMode = powerSaveModeListener,
          scope = scope,
          internetConnectionDialog = internetConnectionDialog,
          networkConnectionMonitor = networkConnectionMonitor,
          eventPublisher = eventPublisher,
          fullScreenSharedConnector = fullScreenSharedConnector,
        )
      }

      else -> {
        // Default for VPAID/MRAID/WEB Ads.
        HyprMXBaseFullScreenWebViewController(
          activity = activity,
          savedInstanceState = savedInstanceState,
          ad = ad,
          hyprMXBaseViewControllerListener = viewControllerListener,
          webViewFactory = webViewFactory,
          clientErrorController = errorCaptureController,
          activityResultListener = activityResultListener,
          openMeasurementController = openMeasurementController,
          powerSaveMode = powerSaveModeListener,
          scope = scope,
          networkConnectionMonitor = networkConnectionMonitor,
          internetConnectionDialog = internetConnectionDialog,
          eventPublisher = eventPublisher,
          fullScreenSharedConnector = fullScreenSharedConnector,
        )
      }
    }.also { controller = it }
  }
}
