package com.hyprmx.android.sdk.activity

import android.os.Bundle
import android.widget.ImageView
import android.widget.TextView
import androidx.activity.addCallback
import androidx.appcompat.app.AppCompatActivity
import com.hyprmx.android.R
import com.hyprmx.android.sdk.utility.HyprMXLog
import com.hyprmx.android.sdk.utility.getColor

/**
 * This package-private class implements the 'No Ads' activity.
 *
 */
internal class HyprMXNoOffersActivity : AppCompatActivity() {

  var noAdController: HyprMXNoAdViewController? = null

  private lateinit var titleView: TextView

  private lateinit var closeButton: ImageView

  private var backPressed: Boolean = false

  /*
   * (non-Javadoc)
   *
   * @see android.app.Activity#onCreate(android.os.Bundle)
   */
  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)

    // If ActivityResultListener instance is null exit Activity.
    if (ActivityDependencyHolder.noAdViewControllerFactory == null) {
      HyprMXLog.w("Cancelling ad. Cannot recreate HyprMXNoOffersActivity.")
      finish()
      return
    }

    ActivityDependencyHolder.noAdViewControllerFactory?.let {
      noAdController = it.createHyprMXNoAdActivityController(this)
    }

    if (savedInstanceState != null) {
      HyprMXLog.d("Cancelling ad because activity was destroyed.")
      noAdController?.onAdDismissed(false)
      finish()
      return
    }

    setContentView(R.layout.hyprmx_no_ad)

    closeButton = findViewById(R.id.hyprmx_close_button)
    closeButton.setOnClickListener { onBackPressedDispatcher.onBackPressed() }

    titleView = findViewById(R.id.hyprmx_no_ad_title)

    // If server sends no_ad component that use them to set no ad view.
    noAdController?.uiComponents?.noAd?.let { noAd ->
      // set the title information
      titleView.text = noAd.title
      titleView.setTextColor(getColor(1f, noAd.titleColor))
      titleView.textSize = noAd.titleSize.toFloat()
    }

    onBackPressedDispatcher.addCallback {
      backPressed = true
      noAdController?.onAdDismissed(false)
      finish()
    }
  }

  override fun onDestroy() {
    if (!backPressed) {
      noAdController?.onAdDismissed(false)
    }
    super.onDestroy()
  }
}
