package com.hyprmx.android.sdk.activity

import android.annotation.SuppressLint
import android.content.Intent
import android.content.pm.PackageManager
import android.content.res.Configuration
import android.os.Build
import android.os.Bundle
import android.view.View
import androidx.activity.addCallback
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AppCompatActivity
import com.hyprmx.android.sdk.utility.HyprMXLog
import com.hyprmx.android.sdk.utility.PermissionResult

/**
 * This package-private class is used to display ads.
 */
internal class HyprMXOfferViewerActivity :
  AppCompatActivity(),
  HyprMXBaseViewController.HyprMXBaseViewControllerListener {

  var hyprMXViewController: HyprMXBaseViewController? = null

  override fun onCreate(savedInstanceState: Bundle?) {
    super.onCreate(savedInstanceState)
    HyprMXLog.d("onCreate")

    overridePendingTransition(0, 0)

    // If ActivityResultListener instance is null exit Activity.
    if (ActivityDependencyHolder.adControllerFactory == null) {
      HyprMXLog.w("Cancelling ad. Cannot recreate HyprMXOfferViewerActivity.")
      finish()
      return
    }

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
      window.decorView.systemUiVisibility = (
        View.SYSTEM_UI_FLAG_LAYOUT_STABLE
          or View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
          or View.SYSTEM_UI_FLAG_FULLSCREEN // hide status bar
          or View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY
        )
    }

    hyprMXViewController = ActivityDependencyHolder.adControllerFactory?.createAdViewController(
      activity = this,
      savedInstanceState = savedInstanceState,
      viewControllerListener = this,
    )?.apply {
      onCreate()
      lifecycle.addObserver(this)
      lifecycle.addObserver(this.powerSaveMode)
    }

    onBackPressedDispatcher.addCallback {
      hyprMXViewController?.onBackButtonPressed()
    }
  }

  public override fun onStart() {
    super.onStart()
    HyprMXLog.d("onStart")
    hyprMXViewController?.onStart()
  }

  public override fun onResume() {
    super.onResume()
    HyprMXLog.d("onResume")
    hyprMXViewController?.onResume()
  }

  public override fun onPause() {
    HyprMXLog.d("onPause")
    super.onPause()
    hyprMXViewController?.onPause()
    if (isFinishing) hyprMXViewController?.notifyAdResultListener()
  }

  public override fun onStop() {
    HyprMXLog.d("onStop")
    hyprMXViewController?.onStop()
    super.onStop()
  }

  public override fun onDestroy() {
    HyprMXLog.d("onDestroy")
    hyprMXViewController?.onDestroy()
    hyprMXViewController = null
    super.onDestroy()
  }

  @SuppressLint("InlinedApi")
  override fun onWindowFocusChanged(hasFocus: Boolean) {
    if (hasFocus) {
      window.decorView.systemUiVisibility = (
        View.SYSTEM_UI_FLAG_LAYOUT_STABLE
          or View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
          or View.SYSTEM_UI_FLAG_FULLSCREEN // hide status bar
          or View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY
        )
    }
  }

  @RequiresApi(Build.VERSION_CODES.LOLLIPOP)
  override fun onRequestPermissionsResult(
    requestCode: Int,
    permissions: Array<String>,
    grantResults: IntArray,
  ) {
    super.onRequestPermissionsResult(requestCode, permissions, grantResults)

    val resultList = ArrayList<PermissionResult>()
    for (i in permissions.indices) {
      resultList.add(PermissionResult(permissions[i], grantResults[i] == PackageManager.PERMISSION_GRANTED))
    }
    hyprMXViewController?.onPermissionResponse(resultList, requestCode)
  }

  override fun onSetRequestedOrientation(requestedOrientation: Int) {
    setRequestedOrientation(requestedOrientation)
  }

  override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
    hyprMXViewController?.onActivityResult(requestCode, resultCode, data)
    super.onActivityResult(requestCode, resultCode, data)
  }

  override fun onConfigurationChanged(newConfig: Configuration) {
    hyprMXViewController?.onConfigurationChanged(newConfig)
    super.onConfigurationChanged(newConfig)
  }

  companion object {
    const val WEBTRAFFIC_OFFER = "web_traffic"
    const val MRAID = "mraid"
  }
}
