@file:Suppress("FunctionName")

package com.hyprmx.android.sdk.analytics

import com.hyprmx.android.sdk.core.js.JSEngine
import com.hyprmx.android.sdk.network.NetworkController

internal interface EventController {
  fun setSharingEndpoint(sharingEndpoint: String)
  fun handleInvalidEndPoint(completionEndpoint: String)
  fun sendTrackWebViewImpression(url: String, viewingId: String)
  suspend fun sendSharingTracking(viewingId: String?)
  fun sendDurationUpdateTracking(token: String, viewingId: String, duration: String)
  fun sendPixelTrackingEvents(imageTagsToFire: String)
}

sealed class EventResult {
  object Success : EventResult()
  class Failure(val resultCode: Int, val message: String) : EventResult()
}

internal fun EventController(
  jsEngine: JSEngine,
  clientErrorController: ClientErrorControllerIf,
  networkController: NetworkController,
): EventController =
  DefaultEventController(
    jsEngine,
    clientErrorController,
    networkController,
  )
