package com.hyprmx.android.sdk.api.data

import com.hyprmx.android.sdk.utility.Result
import org.json.JSONException
import org.json.JSONObject
import java.io.Serializable

internal class CancellationDialog(
  val messageText: String,
  val exitText: String,
  val continueText: String,
) : Serializable {
  companion object {

    fun fromJson(jsonString: String?): Result<CancellationDialog> {
      if (jsonString.isNullOrEmpty()) {
        return Result.Failure("String is null or empty", 0)
      }
      return try {
        val json = JSONObject(jsonString)
        val messageText = json.getString(FIELD_MESSAGE)
        val exitText = json.getString(FIELD_EXIT)
        val continueText = json.getString(FIELD_CONTINUE)

        Result.Success(CancellationDialog(messageText, exitText, continueText))
      } catch (exception: JSONException) {
        Result.Failure("Exception parsing cancellation dialog", 0, exception)
      }
    }

    private const val FIELD_MESSAGE = "message"
    private const val FIELD_EXIT = "exit"
    private const val FIELD_CONTINUE = "continue"
  }
}
