package com.hyprmx.android.sdk.api.data

import org.json.JSONException
import org.json.JSONObject

/**
 * This class provides a representation of the "No Ad" portion of the JSON payload from Initialization and Check Inventory response.
 *
 */
internal class NoAd(val title: String, val titleColor: String, val titleSize: Int) {
  companion object {

    fun fromJson(json: JSONObject): NoAd {
      return try {
        val title = json.optString(FIELD_TITLE, DEFAULT_TITLE)
        val titleColor = json.optString(FIELD_TITLE_COLOR, DEFAULT_TITLE_COLOR)
        val titleSize = json.optInt(FIELD_TITLE_SIZE, DEFAULT_TITLE_SIZE)
        NoAd(title, titleColor, titleSize)
      } catch (exception: JSONException) {
        getDefaultNoAd()
      }
    }

    fun getDefaultNoAd(): NoAd {
      return NoAd(DEFAULT_TITLE, DEFAULT_TITLE_COLOR, DEFAULT_TITLE_SIZE)
    }

    private const val FIELD_TITLE = "title"
    private const val FIELD_TITLE_COLOR = "title_color"
    private const val FIELD_TITLE_SIZE = "title_size"

    private const val DEFAULT_TITLE =
      "This ad is not available based on your response. Tap close or the back key to continue."
    private const val DEFAULT_TITLE_COLOR = "#282828"
    private const val DEFAULT_TITLE_SIZE = 18
  }
}
