package com.hyprmx.android.sdk.api.data

import com.hyprmx.android.sdk.utility.getStringOrNull
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.util.ArrayList

class PresentDialog(
  val title: String?,
  val message: String?,
  val buttons: List<PresentDialogButton>?,
) {

  companion object {

    private const val FIELD_TITLE = "title"
    private const val FIELD_MESSAGE = "message"
    private const val FIELD_BUTTONS = "buttons"

    @Throws(JSONException::class)
    fun fromJsonString(jsonString: String): PresentDialog {
      val jsonObject = JSONObject(jsonString)
      return PresentDialog(
        jsonObject.getStringOrNull(FIELD_TITLE),
        jsonObject.getStringOrNull(FIELD_MESSAGE),
        PresentDialogButton.fromJsonArray(jsonObject.optJSONArray(FIELD_BUTTONS)),
      )
    }
  }

  class PresentDialogButton(val name: String?, val script: String?) {

    companion object {

      private const val FIELD_NAME = "name"
      private const val FIELD_SCRIPT = "script"

      @Throws(JSONException::class)
      fun fromJsonArray(jsonArray: JSONArray?): List<PresentDialogButton>? {
        if (jsonArray == null) {
          return null
        }
        val buttonList = ArrayList<PresentDialogButton>()
        for (i in 0 until jsonArray.length()) {
          val buttonJson = jsonArray.getJSONObject(i)
          buttonList.add(fromJson(buttonJson))
        }
        return buttonList
      }

      @Throws(JSONException::class)
      fun fromJson(jsonObject: JSONObject): PresentDialogButton {
        return PresentDialogButton(
          jsonObject.getStringOrNull(FIELD_NAME),
          jsonObject.getStringOrNull(FIELD_SCRIPT),
        )
      }
    }
  }
}
