package com.hyprmx.android.sdk.api.data

import org.json.JSONException
import org.json.JSONObject

/**
 * This class represents a value set for a RequiredInformation.
 *
 * @param label The string label to display
 * @param value The string value to send if this item is selected
 */

internal class Value(val label: String, val value: String) {
  companion object {
    @Throws(JSONException::class)
    fun fromJson(jsonString: String): Value {
      val jsonObject = JSONObject(jsonString)

      val label = jsonObject.getString(FIELD_LABEL)
      val value = jsonObject.getString(FIELD_VALUE)

      return Value(label, value)
    }

    const val FIELD_LABEL = "Label"
    const val FIELD_VALUE = "Value"
  }
}
