package com.hyprmx.android.sdk.audio

import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import com.hyprmx.android.sdk.core.hyprmxDelegate
import com.hyprmx.android.sdk.core.js.JSEngine
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

internal interface AudioEventPublisher {
  @RetainMethodSignature
  fun onAudioStart()

  @RetainMethodSignature
  fun onAudioEnd()
}

internal class HyprAudioEventPublisher(jsEngine: JSEngine, scope: CoroutineScope) : AudioEventPublisher, CoroutineScope by scope {
  companion object {
    const val JS_CONTROLLER_NAME = "HYPRAudioEventPublisherNative"
  }

  init {
    jsEngine.addJavascriptInterface(this, JS_CONTROLLER_NAME)
  }

  override fun onAudioStart() {
    launch {
      hyprmxDelegate.onAudioStarted()
    }
  }

  override fun onAudioEnd() {
    launch {
      hyprmxDelegate.onAudioEnded()
    }
  }
}
