package com.hyprmx.android.sdk.audio

import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import com.hyprmx.android.sdk.core.js.JSEngine
import java.lang.ref.WeakReference

internal interface AudioManagerNative {
  @RetainMethodSignature
  fun setActive(isActive: Boolean, muteCheckRate: Long)

  @RetainMethodSignature
  fun getVolume(): Double

  @RetainMethodSignature
  fun getIsMuted(): Boolean

  @RetainMethodSignature
  fun getAudioCategory(): String

  @RetainMethodSignature
  fun startAudioSession(): String?
}

internal interface AudioManager {
  fun setActive(isActive: Boolean)

  fun getVolume(): Double

  fun getIsMuted(): Boolean

  fun getAudioCategory(): String

  fun startAudioSession(): String?
}

internal class AudioManagerNativeAdapter(jsEngine: JSEngine, audioManager: AudioManager) : AudioManagerNative {
  init {
    jsEngine.addJavascriptInterface(this, "HYPRNativeAudioListener")
  }

  private val audioManager: WeakReference<AudioManager> = WeakReference(audioManager)
  override fun setActive(isActive: Boolean, muteCheckRate: Long) {
    audioManager.get()?.setActive(isActive)
  }

  override fun getVolume(): Double {
    return audioManager.get()?.getVolume() ?: 0.0
  }

  override fun getIsMuted(): Boolean {
    return audioManager.get()?.getIsMuted() ?: false
  }

  override fun getAudioCategory(): String {
    return audioManager.get()?.getAudioCategory() ?: "Unknown"
  }

  override fun startAudioSession(): String? {
    return audioManager.get()?.startAudioSession()
  }
}
