package com.hyprmx.android.sdk.audio

import com.hyprmx.android.sdk.core.js.JSEngine

internal class AudioManagerSharedImpl(private val jsEngine: JSEngine) : AudioManagerShared {

  override fun onVolumeChange(volume: Volume) {
    jsEngine.evaluate("HYPRAudioStatusManager.onVolumeChange(${volume.currentVolumePercentage});")
  }

  override fun onMuteChange(muted: Boolean) {
    jsEngine.evaluate("HYPRAudioStatusManager.onMuteChange($muted);")
  }
}
