package com.hyprmx.android.sdk.audio

import androidx.annotation.FloatRange
import androidx.annotation.IntRange

data class Volume(
  @IntRange(from = 0) var currentVolume: Int,
  @IntRange(from = 0) var maxVolumeLevel: Int,
  @IntRange(from = 0) var minVolumeLevel: Int = 0,
)

@get:FloatRange(from = 0.0, to = 1.0)
val Volume.currentVolumePercentage: Float
  get() = try {
    currentVolume.toFloat() / (maxVolumeLevel - minVolumeLevel)
  } catch (ex: ArithmeticException) {
    0f
  }
