package com.hyprmx.android.sdk.banner

import com.hyprmx.android.sdk.core.BasePresenter
import com.hyprmx.android.sdk.core.BaseView
import com.hyprmx.android.sdk.core.HyprMXErrors
import com.hyprmx.android.sdk.overlay.HyprMXOverlay

internal interface HyprMXBannerContract {
  interface View : BaseView, HyprMXOverlay {
    fun loadAdSuccess()
    fun loadAdFailure(error: HyprMXErrors)
    fun onAdClicked()
    fun reloadWebView()
    fun removePresenter()

    fun startVisibilityTracking(rate: Long, opacityThresholdPercent: Int)
    fun stopVisibilityTracking()

    fun startOMSession()
    fun finishOMSession()

    fun onAdImpression()
  }

  interface Presenter : BasePresenter<View>, VisibilityChangedListener {
    fun loadAd(definedSize: HyprMXBannerSize, actualWidth: Float, actualHeight: Float, bidResponse: String?)
    fun visibilityChanged(visibility: Int)
    fun onParentViewChanged(attached: Boolean)
    fun onContainerSizeChanged(width: Float, height: Float)
    fun onBannerClicked()
  }
}
