package com.hyprmx.android.sdk.banner

import androidx.annotation.Keep

/**
 * Listener for common load and interaction events
 */
@Keep
interface HyprMXBannerListener {
  /**
   * A click event has occurred on the banner
   *
   * @param view The HyprMXBannerView that had the click event
   */
  fun onAdClicked(view: HyprMXBannerView)

  /**
   * The click event on the banner has transition to an overlay
   *
   * @param view The HyprMXBannerView that had the open event
   */
  fun onAdOpened(view: HyprMXBannerView)

  /**
   * The opened overlay has been dismissed
   *
   * @param view The HyprMXBannerView that had the close event
   */
  fun onAdClosed(view: HyprMXBannerView)

  /**
   * The click event on the banner will open a third party application to
   * process the click
   *
   * @param view The HyprMXBannerView that had the left application event
   */
  @Deprecated(
    message = "This callback will be removed on a future SDK release.\nUse the app's lifecycle or the activity's lifecycle events as alternative.",
  )
  fun onAdLeftApplication(view: HyprMXBannerView)

  /**
   * The impression event on the banner when the banner is considered visible and impressed.
   *
   * @param view The HyprMXBannerView that had the impression event
   */
  fun onAdImpression(view: HyprMXBannerView)
}
