@file:Suppress("FunctionName")

package com.hyprmx.android.sdk.bidding

import com.hyprmx.android.sdk.core.js.JSEngine

internal interface BiddingSessionToken {
  fun getSessionToken(): String
}

internal interface BiddingLoadAd {
  suspend fun loadBid(placementName: String, bidResponseData: String): Boolean
}

internal interface BiddingController : BiddingSessionToken, BiddingLoadAd

internal class DefaultBiddingController(val jsEngine: JSEngine) : BiddingController {
  companion object {
    const val JS_CONTROLLER_NAME = "HYPRBiddingController"
  }

  override fun getSessionToken(): String {
    return jsEngine.evaluateScriptForResponse("$JS_CONTROLLER_NAME.getSessionToken();") as String
  }

  override suspend fun loadBid(placementName: String, bidResponseData: String): Boolean {
    return jsEngine.asyncEvaluateScriptForResponse("loadBid", JS_CONTROLLER_NAME, "['$placementName', '$bidResponseData']") as Boolean
  }
}

internal fun BiddingController(jsEngine: JSEngine) = DefaultBiddingController(jsEngine)
