package com.hyprmx.android.sdk.core

import androidx.annotation.Keep

@Keep
enum class HyprMXErrors {
  NO_FILL {
    override fun toString(): String = "No Fill"
  },
  DISPLAY_ERROR {
    override fun toString(): String = "Display Error"
  },
  PLACEMENT_DOES_NOT_EXIST {
    override fun toString(): String = "Placement Does Not Exist"
  },
  SDK_NOT_INITIALIZED {
    override fun toString(): String = "HyprMX has not been initialized.  Please initialize HyprMX before calling loadAd on HyprMXBannerView"
  },
  AD_SIZE_NOT_SET {
    override fun toString(): String = "Please set the banner size before calling loadAd on HyprMXBannerView"
  },
  PLACEMENT_NAME_NOT_SET {
    override fun toString(): String = "Please set the placement name before calling loadAd on HyprMXBannerView"
  },
  INVALID_BANNER_PLACEMENT_NAME {
    override fun toString(): String = "Placement Name is invalid.  Please check value of placementName used to initialize the banner."
  },
  AD_FAILED_TO_RENDER {
    override fun toString(): String = "Ad failed to Render."
  },
  UNKNOWN {
    override fun toString(): String = "An unknown error has occurred."
  },
}
