package com.hyprmx.android.sdk.core

import com.hyprmx.android.sdk.annotation.RetainMethodSignature

internal interface CaptureImageNativeInterface {
  @RetainMethodSignature
  fun captureImage()
}

internal interface DialogNativeInterface {
  @RetainMethodSignature
  fun showDialog(jsonConfiguration: String)
}

internal interface LaunchBrowserNativeInterface {
  @RetainMethodSignature
  fun hyprMXBrowserClosed()

  @RetainMethodSignature
  fun showHyprMXBrowser(viewModelIdentifier: String)

  @RetainMethodSignature
  fun showPlatformBrowser(url: String)
}

internal interface ActivityEventInterface {
  @RetainMethodSignature
  fun openShareSheet(data: String)

  @RetainMethodSignature
  fun createCalendarEvent(data: String)

  @RetainMethodSignature
  fun storePicture(url: String)

  @RetainMethodSignature
  fun showToast(resourceId: Int)

  @RetainMethodSignature
  fun openOutsideApplication(url: String)
}

internal interface PermissionRequestNativeInterface {
  /**
   * Makes a permission request to the ad
   * @param permissions JSON String array of permissions
   */
  @RetainMethodSignature
  fun permissionRequest(permissions: String, permissionId: Int)
}

internal interface MraidNativeInterface {
  @RetainMethodSignature
  fun useCustomClose(customClose: Boolean)

  @RetainMethodSignature
  fun setOrientationProperties(allowOrientationChange: Boolean, forceOrientationChange: String)
}
