package com.hyprmx.android.sdk.core

import com.hyprmx.android.sdk.api.data.Ad
import com.hyprmx.android.sdk.fullscreen.FullScreenSharedInterface
import com.hyprmx.android.sdk.network.NetworkConnectionMonitor
import com.hyprmx.android.sdk.presentation.ActivityResultListener
import com.hyprmx.android.sdk.presentation.PresentationEventPublisher
import com.hyprmx.android.sdk.tracking.VideoTrackingDelegate
import com.hyprmx.android.sdk.tracking.VideoTrackingDelegateIf
import com.hyprmx.android.sdk.utility.DefaultInternetConnectionDialog
import com.hyprmx.android.sdk.utility.InternetConnectionDialog

internal interface ViewControllerModule : ApplicationModule {
  val ad: Ad
  val activityResultListener: ActivityResultListener
  val networkConnectionMonitor: NetworkConnectionMonitor
  val internetConnectionDialog: InternetConnectionDialog
  val videoTrackingDelegate: VideoTrackingDelegateIf
  val eventPublisher: PresentationEventPublisher
  val fullScreenSharedConnector: FullScreenSharedInterface
}

internal class DefaultViewControllerModule(
  private val applicationModule: ApplicationModule,
  override val ad: Ad,
  override val activityResultListener: ActivityResultListener,
  override val internetConnectionDialog: InternetConnectionDialog =
    DefaultInternetConnectionDialog(),
  override val networkConnectionMonitor: NetworkConnectionMonitor = NetworkConnectionMonitor(
    applicationModule.applicationContext,
  ),
  override val videoTrackingDelegate: VideoTrackingDelegateIf = VideoTrackingDelegate(),
  override val eventPublisher: PresentationEventPublisher,
  override val fullScreenSharedConnector: FullScreenSharedInterface,
) : ViewControllerModule, ApplicationModule by applicationModule
