@file:Suppress("FunctionName")

package com.hyprmx.android.sdk.core.js

import com.hyprmx.android.sdk.analytics.ClientErrorControllerIf
import com.hyprmx.android.sdk.core.ContinuationJS
import java.io.Closeable

internal interface JSEngine : Closeable, ContinuationJS {
  var errorController: ClientErrorControllerIf?
  val uncaughtErrorListeners: MutableList<UncaughtErrorListener>
  val hasFailures: Boolean
  fun insertGlobal(constant: String, constructor: String)
  fun evaluate(script: String)
  fun evaluateScriptForResponse(script: String): Any?
  fun addJavascriptInterface(obj: Any, name: String)
  fun removeJavascriptInterface(name: String)
  fun loadSharedJS(script: String): Boolean
  fun addUncaughtErrorListener(listener: UncaughtErrorListener)
  fun removeUncaughtErrorListener(listener: UncaughtErrorListener)
}

internal interface UncaughtErrorListener {
  fun onUncaughtError(error: String)
}

internal fun JSEngine(): JSEngine = QuickJSEngine()
