package com.hyprmx.android.sdk.footer

import org.json.JSONException
import org.json.JSONObject
import java.io.Serializable

internal class Footer(
  val text: String? = null,
  var bgColor: String? = null,
  val minHeight: Int = 0,
  val icon1: Image? = null,
  val icon2: Image? = null,
  val navOnly: Boolean = false,
) : Serializable {
  companion object {
    const val FIELD_FOOTER = "footer"
    private const val FIELD_TEXT = "text"
    private const val FIELD_BACKGROUND_COLOR = "background_color"
    private const val FIELD_MIN_HEIGHT = "min_height"
    private const val FIELD_IMAGES = "images"
    private const val DEFAULT_MIN_HEIGHT = 51

    @Throws(JSONException::class)
    fun fromJson(jsonObject: JSONObject?): Footer {
      return jsonObject?.let { footerJSONObject ->
        var image1: Image? = null
        var image2: Image? = null
        if (footerJSONObject.has(FIELD_IMAGES)) {
          val images = footerJSONObject.getJSONArray(FIELD_IMAGES)

          image1 = Image.fromJSON(
            jsonObject = images.optJSONObject(0)?.optJSONObject(Image.FIELD_IMAGE),
          )
          image2 = Image.fromJSON(
            jsonObject = images.optJSONObject(1)?.optJSONObject(Image.FIELD_IMAGE),
          )
        }

        Footer(
          footerJSONObject.optString(FIELD_TEXT),
          footerJSONObject.optString(FIELD_BACKGROUND_COLOR),
          footerJSONObject.optInt(FIELD_MIN_HEIGHT, DEFAULT_MIN_HEIGHT),
          image1,
          image2,
        )
      } ?: NAV_ONLY_FOOTER
    }

    val NAV_ONLY_FOOTER = Footer(navOnly = true)
  }
}
