package com.hyprmx.android.sdk.jsAlertDialog

import android.content.Context
import com.hyprmx.android.sdk.api.data.PresentDialog

internal class JSAlertDialogPresenter(
  private val jsAlertDialogView: JSAlertDialogContract.View,
  val webViewPresenter: JSAlertDialogContract.WebViewPresenter,
  private val adDialogPresenter: JSAlertDialogContract.AdDialogPresenter,
) : JSAlertDialogContract.Presenter {

  private val buttonScripts = mutableMapOf<String, String?>()

  init {
    jsAlertDialogView.presenter = this
  }

  override fun createAndShowDialog(context: Context, presentDialog: PresentDialog) {
    if (presentDialog.message == null || presentDialog.buttons.isNullOrEmpty()) {
      return
    }

    presentDialog.buttons.forEach { button ->
      if (button.name != null) {
        buttonScripts[button.name] = button.script
      }
    }

    jsAlertDialogView.showDialog(
      context,
      presentDialog.title,
      presentDialog.message,
      buttonScripts.keys.toList(),
    )
  }

  override fun dismissDialog() {
    jsAlertDialogView.dismissDialog()
  }

  override fun onButtonPressed(name: String) {
    buttonScripts[name]?.let { script ->
      if (script.isNotEmpty()) {
        webViewPresenter.executeJS(script)
      }
    }
  }

  override fun onDialogDisplayed() {
    adDialogPresenter.onDialogDisplayed()
  }

  override fun onDialogDismissed() {
    adDialogPresenter.onDialogDismissed()
  }
}
