package com.hyprmx.android.sdk.jsAlertDialog

import android.app.AlertDialog
import android.content.Context
import com.hyprmx.android.sdk.utility.DetachableClickListener

internal class JSAlertDialogView : JSAlertDialogContract.View {

  override lateinit var presenter: JSAlertDialogContract.Presenter

  private var alertDialog: AlertDialog? = null

  override fun showDialog(
    context: Context,
    title: String?,
    message: String,
    buttonTexts: List<String>,
  ) {
    val detachableClickListeners = ArrayList<DetachableClickListener>()

    alertDialog = AlertDialog.Builder(context)
      .setTitle(title)
      .setMessage(message)
      .setCancelable(false)
      .create()

    buttonTexts.forEachIndexed { i, buttonName ->
      if (i < 3) {
        val buttonClickListener = DetachableClickListener.wrap { dialog, _ ->
          dialog.dismiss()
          presenter.onButtonPressed(buttonName)
        }
        detachableClickListeners.add(buttonClickListener)

        // POSITIVE, NEGATIVE, NEUTRAL buttons are set to -1, -2 and -3
        alertDialog!!.setButton(-i - 1, buttonName, buttonClickListener)
      }
    }

    alertDialog!!.setOnDismissListener {
      alertDialog = null
      presenter.onDialogDismissed()
    }

    alertDialog!!.show()
    detachableClickListeners.forEach { it.clearOnDetach(alertDialog) }
    presenter.onDialogDisplayed()
  }

  override fun dismissDialog() {
    alertDialog?.dismiss()
  }
}
