package com.hyprmx.android.sdk.jsinterface

import android.webkit.JavascriptInterface

interface AppJSInterface {

  fun pageReady()
  fun payoutComplete()
  fun adDidComplete()
  fun closeAd()
  fun setRecoveryPostParameters(params: String)

  fun setClosable(closable: Boolean)
  fun presentDialog(presentDialogJsonString: String)
  fun abort(context: String)
  fun setTrampoline(trampoline: String)

  fun startWebtraffic(webTrafficJsonString: String)

  fun startOMSession(sessionData: String)
  fun endOMSession()
  fun audioEvent(event: String)
  fun setNativeAdConfiguration(data: String)
}

/**
 * Attaching the controller as the javascript interfaces results in the webview holding a
 * hard reference to the controller.
 *
 * Using this delegate allows us to detach the controller from the webview and GC to clean up the controller.
 */
internal class AppJSDelegate(var appJSHandler: AppJSInterface?) : AppJSInterface {
  @JavascriptInterface
  override fun pageReady() {
    appJSHandler?.pageReady()
  }

  @JavascriptInterface
  override fun payoutComplete() {
    appJSHandler?.payoutComplete()
  }

  @JavascriptInterface
  override fun adDidComplete() {
    appJSHandler?.adDidComplete()
  }

  @JavascriptInterface
  override fun closeAd() {
    appJSHandler?.closeAd()
  }

  @JavascriptInterface
  override fun setRecoveryPostParameters(params: String) {
    appJSHandler?.setRecoveryPostParameters(params)
  }

  @JavascriptInterface
  override fun setClosable(closable: Boolean) {
    appJSHandler?.setClosable(closable)
  }

  @JavascriptInterface
  override fun presentDialog(presentDialogJsonString: String) {
    appJSHandler?.presentDialog(presentDialogJsonString)
  }

  @JavascriptInterface
  override fun abort(context: String) {
    appJSHandler?.abort(context)
  }

  @JavascriptInterface
  override fun setTrampoline(trampoline: String) {
    appJSHandler?.setTrampoline(trampoline)
  }

  @JavascriptInterface
  override fun startWebtraffic(webTrafficJsonString: String) {
    appJSHandler?.startWebtraffic(webTrafficJsonString)
  }

  @JavascriptInterface
  override fun startOMSession(sessionData: String) {
    appJSHandler?.startOMSession(sessionData)
  }

  @JavascriptInterface
  override fun endOMSession() {
    appJSHandler?.endOMSession()
  }

  @JavascriptInterface
  override fun audioEvent(event: String) {
    appJSHandler?.audioEvent(event)
  }

  @JavascriptInterface
  override fun setNativeAdConfiguration(data: String) {
    appJSHandler?.setNativeAdConfiguration(data)
  }
}
