package com.hyprmx.android.sdk.jsinterface

import android.webkit.JavascriptInterface
import com.hyprmx.android.sdk.presentation.ArgumentKey.ALLOW_ORIENTATION_CHANGE
import com.hyprmx.android.sdk.presentation.ArgumentKey.FORCE_ORIENTATION_CHANGE
import com.hyprmx.android.sdk.webview.HyprMXJSMessageHandler
import org.json.JSONObject

internal class HyprMXAppJSInterfaceHandler(private val onJSMessageHandler: HyprMXJSMessageHandler) : AppJSInterface {
  @JavascriptInterface
  override fun pageReady() {
    onJSMessageHandler.onJSMessage(::pageReady.name)
  }

  @JavascriptInterface
  override fun payoutComplete() {
    onJSMessageHandler.onJSMessage(::payoutComplete.name)
  }

  @JavascriptInterface
  override fun adDidComplete() {
    onJSMessageHandler.onJSMessage(::adDidComplete.name)
  }

  @JavascriptInterface
  override fun closeAd() {
    onJSMessageHandler.onJSMessage(::closeAd.name)
  }

  @JavascriptInterface
  override fun setRecoveryPostParameters(params: String) {
    onJSMessageHandler.onJSMessage(::setRecoveryPostParameters.name, params)
  }

  @JavascriptInterface
  override fun setClosable(closable: Boolean) {
    onJSMessageHandler.onJSMessage(::setClosable.name, closable.toString())
  }

  @JavascriptInterface
  override fun presentDialog(presentDialogJsonString: String) {
    onJSMessageHandler.onJSMessage(::presentDialog.name, presentDialogJsonString)
  }

  @JavascriptInterface
  override fun abort(context: String) {
    onJSMessageHandler.onJSMessage(::abort.name, context)
  }

  @JavascriptInterface
  override fun setTrampoline(trampoline: String) {
    onJSMessageHandler.onJSMessage(::setTrampoline.name, trampoline)
  }

  @JavascriptInterface
  override fun startWebtraffic(webTrafficJsonString: String) {
    onJSMessageHandler.onJSMessage(::startWebtraffic.name, webTrafficJsonString)
  }

  @JavascriptInterface
  override fun startOMSession(sessionData: String) {
    onJSMessageHandler.onJSMessage(::startOMSession.name, sessionData)
  }

  @JavascriptInterface
  override fun endOMSession() {
    onJSMessageHandler.onJSMessage(::endOMSession.name)
  }

  @JavascriptInterface
  override fun audioEvent(event: String) {
    onJSMessageHandler.onJSMessage(::audioEvent.name, event)
  }

  @JavascriptInterface
  override fun setNativeAdConfiguration(data: String) {
    onJSMessageHandler.onJSMessage(::setNativeAdConfiguration.name, data)
  }

  companion object {
    const val JS_INTERFACE: String = "AndroidOfferViewerJavascriptInterface"
  }
}

internal class HyprMXMraidJSInterfaceHandler(private val onJSMessageHandler: HyprMXJSMessageHandler) {
  @JavascriptInterface
  fun close() {
    onJSMessageHandler.onJSMessage(::close.name)
  }

  @JavascriptInterface
  fun open(url: String) {
    onJSMessageHandler.onJSMessage(::open.name, url)
  }

  @JavascriptInterface
  fun setOrientationProperties(allowOrientationChange: Boolean, forceOrientation: String) {
    // TODO:  Fix up MRAID JS to do the same on both platform. send a JSON object of methodName, args
    onJSMessageHandler.onJSMessage(::setOrientationProperties.name, JSONObject(mapOf(ALLOW_ORIENTATION_CHANGE to allowOrientationChange.toString(), FORCE_ORIENTATION_CHANGE to forceOrientation)).toString())
  }

  @JavascriptInterface
  fun playVideo(url: String) {
    onJSMessageHandler.onJSMessage(::playVideo.name, url)
  }

  @JavascriptInterface
  fun useCustomClose(customClose: Boolean) {
    onJSMessageHandler.onJSMessage(::useCustomClose.name, customClose.toString())
  }

  @JavascriptInterface
  fun createCalendarEvent(params: String) {
    onJSMessageHandler.onJSMessage(::createCalendarEvent.name, params)
  }

  @JavascriptInterface
  fun storePicture(uri: String) {
    onJSMessageHandler.onJSMessage(::storePicture.name, uri)
  }

  companion object {
    const val JS_INTERFACE = "mraidJSInterface"
  }
}
