package com.hyprmx.android.sdk.om

import android.database.ContentObserver
import android.media.AudioManager
import android.os.Handler

class AudioVolumeObserver(
  handler: Handler,
  private val audioManager: AudioManager,
  private val volumeChangeListener: AudioVolumeChangeListener,
  private var lastVolume: Int = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC),
  private val maxVolume: Int = audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC),
) : ContentObserver(handler) {

  override fun onChange(selfChange: Boolean) {
    val currentVolume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC)
    if (currentVolume != lastVolume) {
      lastVolume = currentVolume
      val volumeLevelForOM = convertToVolumeLevelForOM(currentVolume)
      volumeChangeListener.onAudioVolumeChanged(volumeLevelForOM)
    }
  }

  private fun convertToVolumeLevelForOM(currentVolume: Int): Float {
    return currentVolume.toFloat() / maxVolume.toFloat()
  }
}
