package com.hyprmx.android.sdk.om

import android.view.View
import android.webkit.WebView
import com.hyprmx.android.sdk.utility.HyprMXLog
import com.iab.omid.library.jungroup.adsession.AdSession
import com.iab.omid.library.jungroup.adsession.AdSessionConfiguration
import com.iab.omid.library.jungroup.adsession.AdSessionContext
import com.iab.omid.library.jungroup.adsession.CreativeType
import com.iab.omid.library.jungroup.adsession.ImpressionType
import com.iab.omid.library.jungroup.adsession.Owner
import com.iab.omid.library.jungroup.adsession.Partner
import org.json.JSONException

/**
 * Implementation of the Open Measurement session where the ad is run within a webview
 */
internal class OpenMeasurementJSAdSession(
  private val omPartner: Partner,
  private val sessionData: String,
) : OpenMeasurementAdSession {

  override var adSession: AdSession? = null

  @Throws(JSONException::class)
  override fun initializeAdSession(adView: View) {
    val omSessionData = SessionData.fromJsonString(sessionData)

    var videoEventsOwner: Owner = Owner.NONE
    if (omSessionData.forVideo) {
      videoEventsOwner = Owner.JAVASCRIPT
    }

    createAndConfigureHtmlAdSession(
      videoEventsOwner,
      adView as WebView,
      omSessionData.customData,
    )
    registerAdView(adView)
    startSession()
  }

  private fun createAndConfigureHtmlAdSession(
    videoEventsOwner: Owner,
    webView: WebView,
    customData: String?,
  ) {
    try {
      // create context
      val adSessionContext = createAdSessionContext(webView, customData)

      if (adSessionContext == null) {
        HyprMXLog.e("OM AdSessionContext is null.")
        return
      }

      // Designate event layer
      val adSessionConfiguration = AdSessionConfiguration.createAdSessionConfiguration(
        CreativeType.DEFINED_BY_JAVASCRIPT,
        ImpressionType.DEFINED_BY_JAVASCRIPT,
        Owner.JAVASCRIPT,
        videoEventsOwner,
        false,
      )

      if (adSessionConfiguration == null) {
        HyprMXLog.e("OM AdSessionConfiguration is null.")
        return
      }

      // create session
      adSession = AdSession.createAdSession(adSessionConfiguration, adSessionContext)

      if (adSession == null) {
        HyprMXLog.e("OM AdSession is null.")
      }
    } catch (e: IllegalArgumentException) {
      HyprMXLog.e(
        "Error creating or configuring open measurement ad session: ${e.localizedMessage}",
      )
    }
  }

  private fun createAdSessionContext(
    webView: WebView,
    customReferenceData: String?,
  ): AdSessionContext? {
    return AdSessionContext.createHtmlAdSessionContext(
      omPartner,
      webView,
      null,
      customReferenceData,
    )
  }
}
