package com.hyprmx.android.sdk.om

import com.hyprmx.android.sdk.tracking.VideoTracking
import com.hyprmx.android.sdk.utility.HyprMXLog
import com.iab.omid.library.jungroup.adsession.media.InteractionType
import com.iab.omid.library.jungroup.adsession.media.MediaEvents

internal const val DEFAULT_PLAYER_VOLUME = 1.0f

internal class OpenMeasurementTracking(
  private val mediaEvents: MediaEvents,
  private val duration: Float,
) : VideoTracking {

  override suspend fun onStart() {
    HyprMXLog.d("onStart")
    try {
      mediaEvents.start(duration, DEFAULT_PLAYER_VOLUME)
    } catch (e: IllegalArgumentException) {
      HyprMXLog.e("Error notifying video start with error msg - ${e.localizedMessage}")
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video start with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onFirstQuartile() {
    HyprMXLog.d("onFirstQuartile")
    try {
      mediaEvents.firstQuartile()
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video firstQuartile with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onMidPoint() {
    HyprMXLog.d("onMidPoint")
    try {
      mediaEvents.midpoint()
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video midpoint with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onThirdQuartile() {
    HyprMXLog.d("onThirdQuartile")
    try {
      mediaEvents.thirdQuartile()
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video thirdQuartile with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onComplete() {
    HyprMXLog.d("onComplete")
    try {
      mediaEvents.complete()
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video complete with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onPause() {
    HyprMXLog.d("onPause")
    try {
      mediaEvents.pause()
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video pause with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onResume() {
    HyprMXLog.d("onResume")
    try {
      mediaEvents.resume()
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video resume with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onSkip() {
    HyprMXLog.d("onSkip")
    try {
      mediaEvents.skipped()
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video skipped with error msg - ${e.localizedMessage}")
    }
  }

  override suspend fun onClick() {
    HyprMXLog.d("onClick")
    try {
      mediaEvents.adUserInteraction(InteractionType.CLICK)
    } catch (e: IllegalStateException) {
      HyprMXLog.e("Error notifying video adUserInteraction with error msg - ${e.localizedMessage}")
    } catch (e: IllegalArgumentException) {
      HyprMXLog.e("Error notifying video adUserInteraction with error msg - ${e.localizedMessage}")
    }
  }
}
