package com.hyprmx.android.sdk.om

import com.hyprmx.android.sdk.utility.getStringOrNull
import org.json.JSONException
import org.json.JSONObject

internal class SessionData(val forVideo: Boolean, val customData: String?) {

  companion object {

    private const val FIELD_FOR_VIDEO = "forVideo"
    private const val FIELD_CUSTOM_DATA = "customData"

    @Throws(JSONException::class)
    fun fromJsonString(jsonString: String): SessionData {
      val jsonObject = JSONObject(jsonString)
      return SessionData(
        jsonObject.getBoolean(FIELD_FOR_VIDEO),
        jsonObject.getStringOrNull(FIELD_CUSTOM_DATA),
      )
    }
  }
}
