package com.hyprmx.android.sdk.placement

import androidx.annotation.Keep

/**
 * Listener for when the ad associated with the placement is not longer available (expired)
 */
@Keep
interface HyprMXPlacementExpiryListener {
  /**
   * An ad is no longer available for the placement
   *
   * @param placement The placement that expired
   */
  fun onAdExpired(placement: Placement)
}
