package com.hyprmx.android.sdk.placement

import androidx.annotation.Keep

/**
 * The listener interface that the SDK calls to and that clients should implement to know the state of the placement.
 * This will also return a reward if the placement is rewarded.
 */
@Keep
interface HyprMXRewardedShowListener : HyprMXShowListener {

  /**
   * The ad was rewarded for the placement and will be called before ad finished is called
   * This will only be called for rewarded placements
   *
   * @param placement The placement that was rewarded
   * @param rewardName The name of the reward
   * @param rewardValue The value of the reward
   */
  fun onAdRewarded(placement: Placement, rewardName: String, rewardValue: Int)
}
