package com.hyprmx.android.sdk.preferences

import android.content.Context
import android.content.SharedPreferences
import com.hyprmx.android.sdk.annotation.RetainMethodSignature
import com.hyprmx.android.sdk.core.HyprMXController
import com.hyprmx.android.sdk.core.js.JSEngine

/**
 * This class is used to send and receive "persistent id" and "ad is opted out" from shared JS.
 */
internal class LocalStorageController(appContext: Context, jsEngine: JSEngine) {

  // This has to be accessed lazily from the IO thread to avoid
  // disk reads on the main thread.
  internal val preferences: SharedPreferences by lazy {
    appContext.getSharedPreferences(
      HyprMXController.HYPRMX_PREFS_INTERNAL,
      Context.MODE_PRIVATE,
    )
  }

  companion object {
    const val JSCONTROLLER = "hyprMXLocalStorage"
    const val PERSISTENT_ID_KEY = "persistent_id"
    const val OPTED_OUT_KEY = "ad_id_opted_out"
  }

  init {
    jsEngine.addJavascriptInterface(this, JSCONTROLLER)
  }

  @RetainMethodSignature
  fun getItem(key: String): String? {
    when (key) {
      OPTED_OUT_KEY -> preferences.getString(key, "false")
      else -> preferences.getString(key, null) // for PERSISTENT_ID_KEY and other keys
    }.let { return it }
  }

  @RetainMethodSignature
  fun setItem(key: String, value: String) {
    preferences.edit().putString(key, value).apply()
  }
}
