package com.hyprmx.android.sdk.preload

import com.hyprmx.android.sdk.core.js.JSEngine

internal interface PreloadControllerSharedInterface {
  fun nativePreloadDidRemove(viewModelIdentifier: String)
  fun addJavascriptInterface(obj: Any)
}

internal class PreloadControllerSharedConnector(private val jsEngine: JSEngine) :
  PreloadControllerSharedInterface {

  override fun nativePreloadDidRemove(viewModelIdentifier: String) {
    jsEngine.evaluate("$JS_CONTROLLER.nativePreloadDidRemove('$viewModelIdentifier')")
  }

  override fun addJavascriptInterface(obj: Any) {
    jsEngine.addJavascriptInterface(obj, JS_INTERFACE_NAME)
  }

  companion object {
    private const val JS_CONTROLLER = "HYPRPreloadController"
    private const val JS_INTERFACE_NAME = "HYPRCacheListener"
  }
}
